/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.compressor;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.utils.Assert;
import java.io.Closeable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public abstract class ICompressor
implements Closeable,
AutoCloseable {
    public ICompressor(int compressionLevel) {
        if (compressionLevel != -1) {
            Assert.valueRange(compressionLevel, this.getMinCompressionLevel(), this.getMaxCompressionLevel());
        }
    }

    public static ICompressor getInstance(Class<? extends ICompressor> tClass) {
        try {
            Constructor<? extends ICompressor> constructor = tClass.getDeclaredConstructor(Integer.TYPE);
            constructor.setAccessible(true);
            return constructor.newInstance(ICompressor.getDefaultCompressionLevel(tClass));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static ICompressor getInstance(Class<? extends ICompressor> tClass, int compressionLevel) {
        try {
            Constructor<? extends ICompressor> constructor = tClass.getDeclaredConstructor(Integer.TYPE);
            constructor.setAccessible(true);
            return constructor.newInstance(compressionLevel);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static int getMaxCompressionLevel(Class<? extends ICompressor> tClass) {
        try {
            return (Integer)tClass.getDeclaredField("MAX_LEVEL").get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static int getMinCompressionLevel(Class<? extends ICompressor> tClass) {
        try {
            return (Integer)tClass.getDeclaredField("MIN_LEVEL").get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static int getDefaultCompressionLevel(Class<? extends ICompressor> tClass) {
        try {
            return (Integer)tClass.getDeclaredField("DEFAULT_LEVEL").get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String getCompressorName(Class<? extends ICompressor> tClass) {
        try {
            return (String)tClass.getDeclaredField("COMPRESSOR_NAME").get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Bytes compress(Class<? extends ICompressor> tClass, byte[] src, int offset, int length) {
        try (ICompressor compressor = ICompressor.getInstance(tClass);){
            ByteStream bs = new ByteStream(compressor.getCompressBound(length));
            compressor.compress(src, offset, length, bs);
            Bytes bytes = bs.toBytes();
            return bytes;
        }
    }

    public static Bytes compress(Class<? extends ICompressor> tClass, Bytes src) {
        return ICompressor.compress(tClass, src.bytes(), src.offset(), src.length());
    }

    public abstract int getCompressBound(int var1);

    public abstract int getMinCompressionLevel();

    public abstract int getDefaultCompressionLevel();

    public abstract int getMaxCompressionLevel();

    public abstract int compress(byte[] var1, int var2, int var3, byte[] var4, int var5);

    @Override
    public abstract void close();

    public final int compress(Bytes src, ByteStream dst) {
        return this.compress(src.bytes(), src.offset(), src.length(), dst);
    }

    public final int compress(byte[] src, int srcOffset, int srcLength, ByteStream dst) {
        int requestSize = this.getCompressBound(srcLength);
        dst.wRequire(requestSize);
        int length0 = this.compress(src, srcOffset, srcLength, dst.bytes(), dst.wTell());
        dst.wSeek(dst.wTell() + length0);
        return length0;
    }
}

