/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.compressor;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public abstract class IDecompressor
implements AutoCloseable {
    public static IDecompressor getInstance(Class<? extends IDecompressor> tClass) {
        try {
            Constructor<? extends IDecompressor> constructor = tClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String getCompressorName(Class<? extends IDecompressor> tClass) {
        try {
            return (String)tClass.getDeclaredField("COMPRESSOR_NAME").get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Bytes decompress(Class<? extends IDecompressor> tClass, byte[] src, int offset, int length) {
        try (IDecompressor decompressor = IDecompressor.getInstance(tClass);){
            ByteStream dst = new ByteStream(decompressor.getDecompressBound(src, offset, length));
            decompressor.decompress(src, offset, length, dst);
            Bytes bytes = dst.toBytes();
            return bytes;
        }
    }

    public static Bytes decompress(Class<? extends IDecompressor> tClass, Bytes src) {
        return IDecompressor.decompress(tClass, src.bytes(), src.offset(), src.length());
    }

    public abstract int getDecompressBound(byte[] var1, int var2, int var3);

    public abstract int decompress(byte[] var1, int var2, int var3, byte[] var4, int var5);

    @Override
    public abstract void close();

    public final int decompress(Bytes src, ByteStream dst) {
        return this.decompress(src.bytes(), src.offset(), src.length(), dst);
    }

    public final int decompress(byte[] src, int offset, int length, ByteStream dst) {
        int requestSize = this.getDecompressBound(src, offset, length);
        dst.wRequire(requestSize);
        int length0 = this.decompress(src, offset, length, dst.bytes(), dst.end());
        dst.wSeek(dst.wTell() + length0);
        return length0;
    }
}

