/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.compressor.gzip;

import edu.sysu.pmglab.ccf.compressor.CompressorRuntimeException;
import edu.sysu.pmglab.ccf.compressor.gzip.GZIPOutputStream;
import edu.sysu.pmglab.ccf.compressor.gzip.MemoryByteOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class GZIPCompressStreamCtx {
    final MemoryByteOutputStream wrapper;
    final int compressionLevel;

    GZIPCompressStreamCtx(int compressionLevel) {
        this.compressionLevel = compressionLevel;
        this.wrapper = new MemoryByteOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int compress(byte[] src, int srcOffset, int srcLength, byte[] dst, int dstOffset) {
        int n;
        this.wrapper.wrap(dst, dstOffset);
        GZIPOutputStream outputStream2 = new GZIPOutputStream((OutputStream)this.wrapper, this.compressionLevel);
        outputStream2.write(src, srcOffset, srcLength);
        outputStream2.finish();
        try {
            n = this.wrapper.size() - dstOffset;
        }
        catch (Throwable throwable) {
            try {
                outputStream2.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new CompressorRuntimeException(e);
            }
        }
        outputStream2.close();
        return n;
    }
}

