/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.compressor.gzip;

import edu.sysu.pmglab.ccf.compressor.ICompressor;
import edu.sysu.pmglab.ccf.compressor.gzip.GZIPCompressStreamCtx;
import edu.sysu.pmglab.utils.Assert;

public class GZIPCompressor
extends ICompressor {
    public static final int MIN_LEVEL = 0;
    public static final int MAX_LEVEL = 9;
    public static final int DEFAULT_LEVEL = 5;
    public static final String COMPRESSOR_NAME = "GZIP";
    final GZIPCompressStreamCtx compressor;

    public GZIPCompressor() {
        this(5);
    }

    public GZIPCompressor(int compressionLevel) {
        super(compressionLevel);
        if (compressionLevel == -1) {
            compressionLevel = 5;
        }
        this.compressor = new GZIPCompressStreamCtx(compressionLevel);
    }

    @Override
    public int getCompressBound(int length) {
        Assert.valueRange(length, 0, 2140847020);
        return (int)Math.max(7680.0, 1.0031 * (double)length);
    }

    @Override
    public int getMinCompressionLevel() {
        return 0;
    }

    @Override
    public int getDefaultCompressionLevel() {
        return 5;
    }

    @Override
    public int getMaxCompressionLevel() {
        return 9;
    }

    @Override
    public int compress(byte[] src, int srcOffset, int srcLength, byte[] dst, int dstOffset) {
        return this.compressor.compress(src, srcOffset, srcLength, dst, dstOffset);
    }

    @Override
    public void close() {
    }
}

