/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.compressor.gzip;

import edu.sysu.pmglab.ccf.compressor.CompressorRuntimeException;
import edu.sysu.pmglab.ccf.compressor.gzip.MemoryByteInputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;

class GZIPDecompressStreamCtx {
    final MemoryByteInputStream wrapper = new MemoryByteInputStream();

    GZIPDecompressStreamCtx() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int decompress(byte[] src, int srcOffset, int srcLength, byte[] dst, int dstOffset) {
        this.wrapper.wrap(src, srcOffset, srcOffset + srcLength);
        try (GZIPInputStream inputStream2 = new GZIPInputStream(this.wrapper);){
            int n = inputStream2.read(dst, dstOffset, dst.length - dstOffset);
            return n;
        }
        catch (IOException e) {
            throw new CompressorRuntimeException(e);
        }
    }
}

