/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.compressor.gzip;

import edu.sysu.pmglab.ccf.compressor.IDecompressor;
import edu.sysu.pmglab.ccf.compressor.gzip.GZIPDecompressStreamCtx;
import edu.sysu.pmglab.utils.Assert;

public final class GZIPDecompressor
extends IDecompressor {
    public static final String COMPRESSOR_NAME = "GZIP";
    final GZIPDecompressStreamCtx decompressor = new GZIPDecompressStreamCtx();

    @Override
    public int getDecompressBound(byte[] src, int offset, int length) {
        Assert.that(length >= 4);
        return src[offset + length - 4] & 0xFF | (src[offset + length - 3] & 0xFF) << 8 | (src[offset + length - 2] & 0xFF) << 16 | (src[offset + length - 1] & 0xFF) << 24;
    }

    @Override
    public int decompress(byte[] src, int srcOffset, int srcLength, byte[] dst, int dstOffset) {
        return this.decompressor.decompress(src, srcOffset, srcLength, dst, dstOffset);
    }

    @Override
    public void close() {
    }
}

