/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.compressor.gzip;

import edu.sysu.pmglab.utils.Assert;
import java.io.OutputStream;

class MemoryByteOutputStream
extends OutputStream {
    byte[] cache;
    int start;
    int end;
    int seek;

    public MemoryByteOutputStream() {
        this.cache = new byte[16];
    }

    public MemoryByteOutputStream(int capacity) {
        this.cache = new byte[capacity];
    }

    public MemoryByteOutputStream(byte[] cache) {
        this.wrap(cache, 0);
    }

    public MemoryByteOutputStream(byte[] cache, int start) {
        this.wrap(cache, start);
    }

    public MemoryByteOutputStream(byte[] cache, int start, int end) {
        this.wrap(cache, start, end);
    }

    public void write(byte element) {
        if (this.seek == this.end) {
            throw new IndexOutOfBoundsException("index out of bounds");
        }
        this.cache[this.seek++] = element;
    }

    @Override
    public void write(int element) {
        this.write((byte)element);
    }

    @Override
    public void write(byte[] src) {
        this.write(src, 0, src.length);
    }

    @Override
    public void write(byte[] src, int offset, int length) {
        this.write0(src, offset, length);
    }

    @Override
    public void close() {
    }

    private int write0(byte[] src, int offset, int length) {
        if (this.seek + length > this.end) {
            throw new IndexOutOfBoundsException("index out of bounds");
        }
        System.arraycopy(src, offset, this.cache, this.seek, length);
        this.seek += length;
        return length;
    }

    public byte[] getCache() {
        return this.cache;
    }

    public void wrap(byte[] src) {
        Assert.that(src != null);
        this.cache = src;
        this.start = 0;
        this.end = src.length;
        this.seek = 0;
    }

    public void wrap(byte[] src, int start) {
        Assert.that(src != null);
        Assert.valueRange(start, 0, src.length);
        this.cache = src;
        this.start = start;
        this.end = src.length;
        this.seek = this.start;
    }

    public void wrap(byte[] src, int start, int end) {
        Assert.that(src != null);
        Assert.valueRange(start, 0, end);
        Assert.valueRange(end, this.start, src.length);
        this.cache = src;
        this.start = start;
        this.end = end;
        this.seek = this.start;
    }

    public int getCapacity() {
        if (null == this.cache) {
            return -1;
        }
        return this.end - this.start;
    }

    public int size() {
        return this.seek - this.start;
    }

    public int remaining() {
        return this.end - this.seek;
    }

    public void reset() {
        this.seek = this.start;
    }

    public void freeMemory() {
        this.cache = null;
        this.seek = -1;
        this.start = -1;
    }
}

