/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.compressor.lz4;

import edu.sysu.pmglab.ccf.compressor.ICompressor;
import net.jpountz.lz4.LZ4CompressorWithLength;
import net.jpountz.lz4.LZ4Factory;

public final class LZ4Compressor
extends ICompressor {
    public static final int MIN_LEVEL = 0;
    public static final int MAX_LEVEL = 17;
    public static final int DEFAULT_LEVEL = 0;
    public static final String COMPRESSOR_NAME = "LZ4";
    final LZ4CompressorWithLength compressor;

    public LZ4Compressor() {
        this(0);
    }

    public LZ4Compressor(int compressionLevel) {
        super(compressionLevel);
        if (compressionLevel == -1) {
            compressionLevel = 0;
        }
        this.compressor = compressionLevel == 0 ? new LZ4CompressorWithLength(LZ4Factory.fastestInstance().fastCompressor()) : new LZ4CompressorWithLength(LZ4Factory.fastestInstance().highCompressor(compressionLevel));
    }

    @Override
    public int getCompressBound(int length) {
        return this.compressor.maxCompressedLength(length);
    }

    @Override
    public int getMinCompressionLevel() {
        return 0;
    }

    @Override
    public int getDefaultCompressionLevel() {
        return 0;
    }

    @Override
    public int getMaxCompressionLevel() {
        return 17;
    }

    @Override
    public int compress(byte[] src, int srcOffset, int srcLength, byte[] dst, int dstOffset) {
        return this.compressor.compress(src, srcOffset, srcLength, dst, dstOffset);
    }

    @Override
    public void close() {
    }
}

