/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.compressor.lzma;

import edu.sysu.pmglab.utils.Assert;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

class ByteInputStream
extends InputStream {
    private byte[] cache;
    private int start;
    private int end;
    private int seek;

    public ByteInputStream() {
    }

    public ByteInputStream(byte[] cache) {
        this.wrap(cache, 0);
    }

    public ByteInputStream(byte[] cache, int start) {
        this.wrap(cache, start);
    }

    public ByteInputStream(byte[] cache, int start, int end) {
        this.wrap(cache, start, end);
    }

    @Override
    public int read() throws IOException {
        if (this.seek == this.end) {
            return -1;
        }
        return this.cache[this.seek++] & 0xFF;
    }

    public byte[] read(int nByte) throws IOException {
        byte[] cache = new byte[nByte];
        int length = this.read(cache);
        if (length == nByte) {
            return cache;
        }
        if (length == -1) {
            return null;
        }
        return Arrays.copyOfRange(cache, 0, length);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        if (this.seek == this.end) {
            return -1;
        }
        int byteToWrite = Math.min(len, this.remaining());
        System.arraycopy(this.cache, this.seek, b, off, byteToWrite);
        this.seek += byteToWrite;
        return byteToWrite;
    }

    public byte[] getCache() {
        return this.cache;
    }

    public void wrap(byte[] src) {
        if (src == null) {
            throw new NullPointerException("src is null");
        }
        this.cache = src;
        this.start = 0;
        this.end = src.length;
        this.seek = this.start;
    }

    public void wrap(byte[] src, int start, int end) {
        Assert.that(src != null);
        Assert.valueRange(start, 0, end);
        Assert.valueRange(end, this.start, src.length);
        this.cache = src;
        this.start = start;
        this.end = end;
        this.seek = this.start;
    }

    public void wrap(byte[] src, int start) {
        Assert.that(src != null);
        Assert.valueRange(start, 0, this.end);
        this.cache = src;
        this.start = start;
        this.end = src.length;
        this.seek = this.start;
    }

    public int remaining() {
        return this.end - this.seek;
    }

    @Override
    public void reset() {
        this.seek = this.start;
    }

    @Override
    public long skip(long n) throws IOException {
        long byteToWrite = Math.min(n, (long)this.remaining());
        this.seek = (int)((long)this.seek + byteToWrite);
        return byteToWrite;
    }

    @Override
    public int available() {
        return this.end - this.start;
    }

    @Override
    public void close() {
    }

    public void freeMemory() {
        this.cache = null;
        this.start = -1;
        this.end = -1;
        this.seek = -1;
    }
}

