/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.compressor.lzma;

import edu.sysu.pmglab.ccf.compressor.lzma.ByteOutputStream;
import edu.sysu.pmglab.ccf.compressor.lzma.ILZMACompressCtx;
import java.io.IOException;
import org.tukaani.xz.ArrayCache;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.UnsupportedOptionsException;
import org.tukaani.xz.lz.LZEncoder;
import org.tukaani.xz.lzma.LZMAEncoder;
import org.tukaani.xz.rangecoder.RangeEncoderToStream;

class LZMACompressCtx
extends ILZMACompressCtx {
    final ByteOutputStream wrapper;
    final RangeEncoderToStream rc;
    final int props;
    final byte[] dictSizeByteArray;
    final LZEncoder lz;
    final LZMAEncoder lzma;

    LZMACompressCtx(int compressionLevel) {
        LZMA2Options options;
        try {
            options = new LZMA2Options(compressionLevel);
        }
        catch (UnsupportedOptionsException e) {
            throw new IllegalArgumentException(e);
        }
        this.wrapper = new ByteOutputStream();
        this.rc = new RangeEncoderToStream(this.wrapper);
        this.props = (options.getPb() * 5 + options.getLp()) * 9 + options.getLc();
        this.dictSizeByteArray = new byte[4];
        int dictSize = options.getDictSize();
        for (int i = 0; i < 4; ++i) {
            this.dictSizeByteArray[i] = (byte)(dictSize & 0xFF);
            dictSize >>>= 8;
        }
        this.lzma = LZMAEncoder.getInstance(this.rc, options, ArrayCache.getDefaultCache());
        this.lz = this.lzma.getLZEncoder();
    }

    @Override
    int compress(byte[] src, int srcOffset, int srcLength, byte[] dst, int dstOffset) throws IOException {
        this.wrapper.wrap(dst, dstOffset);
        this.wrapper.write(this.props);
        this.wrapper.write(this.dictSizeByteArray);
        this.wrapper.write(srcLength & 0xFF);
        this.wrapper.write(srcLength >> 8 & 0xFF);
        this.wrapper.write(srcLength >> 16 & 0xFF);
        this.wrapper.write(srcLength >> 24 & 0xFF);
        this.wrapper.write(0);
        this.wrapper.write(0);
        this.wrapper.write(0);
        this.wrapper.write(0);
        while (srcLength > 0) {
            int used = this.lz.fillWindow(src, srcOffset, srcLength);
            srcOffset += used;
            srcLength -= used;
            this.lzma.encodeForLZMA1();
        }
        this.lz.setFinishing();
        this.lzma.encodeForLZMA1();
        this.rc.finish();
        this.rc.reset();
        this.lzma.reset();
        return this.wrapper.size() - dstOffset;
    }

    @Override
    void close() {
    }
}

