/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.compressor.lzma;

import edu.sysu.pmglab.ccf.compressor.lzma.ByteOutputStream;
import edu.sysu.pmglab.ccf.compressor.lzma.ILZMACompressCtx;
import java.io.IOException;
import java.io.OutputStream;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.LZMAOutputStream;
import org.tukaani.xz.UnsupportedOptionsException;

class LZMACompressStreamCtx
extends ILZMACompressCtx {
    final ByteOutputStream wrapper;
    final LZMA2Options options;

    LZMACompressStreamCtx(int compressionLevel) throws UnsupportedOptionsException {
        this.options = new LZMA2Options(compressionLevel);
        this.wrapper = new ByteOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    int compress(byte[] src, int srcOffset, int srcLength, byte[] dst, int dstOffset) throws IOException {
        this.wrapper.wrap(dst, dstOffset);
        LZMAOutputStream outputStream2 = new LZMAOutputStream((OutputStream)this.wrapper, this.options, srcLength);
        outputStream2.write(src, srcOffset, srcLength);
        outputStream2.finish();
        try {
            int n = this.wrapper.size() - dstOffset;
            return n;
        }
        finally {
            outputStream2.close();
        }
    }

    @Override
    void close() {
    }
}

