/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.compressor.lzma;

import edu.sysu.pmglab.ccf.compressor.ICompressor;
import edu.sysu.pmglab.ccf.compressor.lzma.ILZMACompressCtx;
import edu.sysu.pmglab.ccf.compressor.lzma.LZMACompressCtx;
import edu.sysu.pmglab.utils.Assert;
import java.io.IOException;

public class LZMACompressor
extends ICompressor {
    public static final int MIN_LEVEL = 0;
    public static final int MAX_LEVEL = 9;
    public static final int DEFAULT_LEVEL = 3;
    public static final String COMPRESSOR_NAME = "LZMA";
    final ILZMACompressCtx compressor;

    public LZMACompressor() {
        this(3);
    }

    public LZMACompressor(int compressionLevel) {
        super(compressionLevel);
        if (compressionLevel == -1) {
            compressionLevel = 3;
        }
        this.compressor = new LZMACompressCtx(compressionLevel);
    }

    @Override
    public int getCompressBound(int length) {
        Assert.valueRange(length, 0, 2112209743);
        return (int)Math.max(7680.0, 1.0167 * (double)length);
    }

    @Override
    public int getMinCompressionLevel() {
        return 0;
    }

    @Override
    public int getDefaultCompressionLevel() {
        return 3;
    }

    @Override
    public int getMaxCompressionLevel() {
        return 9;
    }

    @Override
    public int compress(byte[] src, int srcOffset, int srcLength, byte[] dst, int dstOffset) {
        try {
            return this.compressor.compress(src, srcOffset, srcLength, dst, dstOffset);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        this.compressor.close();
    }
}

