/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.compressor.lzma;

import edu.sysu.pmglab.ccf.compressor.lzma.ByteInputStream;
import edu.sysu.pmglab.ccf.compressor.lzma.ILZMADecompressCtx;
import java.io.IOException;
import org.tukaani.xz.ArrayCache;
import org.tukaani.xz.CorruptedInputException;
import org.tukaani.xz.UnsupportedOptionsException;
import org.tukaani.xz.lz.LZDecoder;
import org.tukaani.xz.lzma.LZMADecoder;
import org.tukaani.xz.rangecoder.RangeDecoderFromStream;

class LZMADecompressCtx
extends ILZMADecompressCtx {
    public static final int DICT_SIZE_MAX = 0x7FFFFFF0;
    final ByteInputStream wrapper = new ByteInputStream();
    RangeDecoderFromStream rc;
    LZDecoder lz;
    LZMADecoder lzma;
    int props = -1;
    int dictSize = -1;
    int pb;
    int lp;
    int lc;

    LZMADecompressCtx() {
    }

    private static int getDictSize(int dictSize) {
        if (dictSize < 0 || dictSize > 0x7FFFFFF0) {
            throw new IllegalArgumentException("LZMA dictionary is too big for this implementation");
        }
        return Math.max(dictSize, 4096) + 15 & 0xFFFFFFF0;
    }

    @Override
    int decompress(byte[] src, int srcOffset, int srcLength, byte[] dst, int dstOffset) throws IOException {
        boolean lzmarebuild = false;
        boolean lzrebuild = false;
        this.wrapper.wrap(src, srcOffset);
        int currentProps = this.wrapper.read();
        if (this.props != currentProps) {
            this.props = currentProps;
            if (currentProps > 224) {
                throw new CorruptedInputException("Invalid LZMA properties byte");
            }
            this.pb = currentProps / 45;
            this.lp = (currentProps -= this.pb * 9 * 5) / 9;
            this.lc = currentProps - this.lp * 9;
            if (this.lc < 0 || this.lc > 8 || this.lp < 0 || this.lp > 4) {
                throw new IllegalArgumentException();
            }
            lzmarebuild = true;
        }
        int currentDictSize = 0;
        for (int i = 0; i < 4; ++i) {
            currentDictSize |= this.wrapper.read() << 8 * i;
        }
        if (currentDictSize < 0 || currentDictSize > 0x7FFFFFF0) {
            throw new UnsupportedOptionsException("LZMA dictionary is too big for this implementation");
        }
        long uncompSize = 0L;
        for (int i = 0; i < 8; ++i) {
            uncompSize |= (long)this.wrapper.read() << 8 * i;
        }
        if (uncompSize == 0L) {
            return 0;
        }
        if (uncompSize > 0x7FFFFFFDL) {
            throw new UnsupportedOptionsException("Src is too big (over 2GB)");
        }
        if (this.dictSize != (currentDictSize = LZMADecompressCtx.getDictSize((int)Math.min((long)currentDictSize, uncompSize)))) {
            this.dictSize = currentDictSize;
            lzrebuild = true;
        }
        int dstLength = dst.length - dstOffset;
        if (uncompSize < -1L || (long)dstLength < uncompSize) {
            throw new UnsupportedOptionsException("Uncompressed size is too big");
        }
        if (this.rc == null) {
            this.rc = new RangeDecoderFromStream(this.wrapper);
            this.lz = new LZDecoder(LZMADecompressCtx.getDictSize(currentDictSize), null, ArrayCache.getDefaultCache());
            this.lzma = new LZMADecoder(this.lz, this.rc, this.lc, this.lp, this.pb);
        } else {
            if (lzrebuild) {
                this.lz.reset(LZMADecompressCtx.getDictSize(currentDictSize));
            } else {
                this.lz.reset();
            }
            this.rc.reWrap();
            if (lzmarebuild) {
                this.lzma = new LZMADecoder(this.lz, this.rc, this.lc, this.lp, this.pb);
            } else {
                this.lzma.reset();
            }
        }
        int size = 0;
        while (dstLength > 0) {
            int copySizeMax = (int)Math.min((long)dstLength, uncompSize);
            this.lz.setLimit(copySizeMax);
            try {
                this.lzma.decode();
            }
            catch (CorruptedInputException e) {
                if (uncompSize != -1L || !this.lzma.endMarkerDetected()) {
                    throw e;
                }
                this.rc.normalize();
            }
            int copiedSize = this.lz.flush(dst, dstOffset);
            dstOffset += copiedSize;
            dstLength -= copiedSize;
            size += copiedSize;
            if (uncompSize < 0L || (uncompSize -= (long)copiedSize) != 0L) continue;
            if (this.lz.hasPending() || !this.rc.isFinished()) {
                throw new CorruptedInputException();
            }
            return size == 0 ? -1 : size;
        }
        return size;
    }

    @Override
    void close() {
        this.rc = null;
        this.lz = null;
        this.lzma = null;
    }
}

