/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.compressor.lzma;

import edu.sysu.pmglab.ccf.compressor.CompressorRuntimeException;
import edu.sysu.pmglab.ccf.compressor.IDecompressor;
import edu.sysu.pmglab.ccf.compressor.lzma.ILZMADecompressCtx;
import edu.sysu.pmglab.ccf.compressor.lzma.LZMADecompressCtx;
import edu.sysu.pmglab.utils.Assert;
import java.io.IOException;

public class LZMADecompressor
extends IDecompressor {
    public static final String COMPRESSOR_NAME = "LZMA";
    final ILZMADecompressCtx decompressor = new LZMADecompressCtx();

    @Override
    public int getDecompressBound(byte[] src, int offset, int length) {
        Assert.that(length >= 18);
        long size = 0L;
        for (int i = 0; i < 8; ++i) {
            size |= (long)(src[i + offset + 5] & 0xFF) << 8 * i;
        }
        Assert.valueRange((int)size, 0, 0x7FFFFFFD);
        return (int)size;
    }

    @Override
    public final int decompress(byte[] src, int srcOffset, int srcLength, byte[] dst, int dstOffset) {
        try {
            return this.decompressor.decompress(src, srcOffset, srcLength, dst, dstOffset);
        }
        catch (IOException e) {
            throw new CompressorRuntimeException(e);
        }
    }

    @Override
    public void close() {
        this.decompressor.close();
    }
}

