/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.compressor.zstd;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdCompressCtx;
import edu.sysu.pmglab.ccf.compressor.ICompressor;
import edu.sysu.pmglab.utils.Assert;

public final class ZstdCompressor
extends ICompressor {
    public static final int MIN_LEVEL = 0;
    public static final int MAX_LEVEL = 22;
    public static final int DEFAULT_LEVEL = 4;
    public static final String COMPRESSOR_NAME = "ZSTD";
    final ZstdCompressCtx compressor = new ZstdCompressCtx();

    public ZstdCompressor() {
        this(4);
    }

    public ZstdCompressor(int compressionLevel) {
        super(compressionLevel);
        if (compressionLevel == -1) {
            compressionLevel = 4;
        }
        this.compressor.setLevel(compressionLevel);
    }

    @Override
    public int getCompressBound(int length) {
        Assert.valueRange(length, 0, 2139127678);
        return (int)Zstd.compressBound(length);
    }

    @Override
    public int getMinCompressionLevel() {
        return 0;
    }

    @Override
    public int getDefaultCompressionLevel() {
        return 4;
    }

    @Override
    public int getMaxCompressionLevel() {
        return 22;
    }

    @Override
    public int compress(byte[] src, int srcOffset, int srcLength, byte[] dst, int dstOffset) {
        return this.compressor.compressByteArray(dst, dstOffset, dst.length - dstOffset, src, srcOffset, srcLength);
    }

    @Override
    public void close() {
        this.compressor.close();
    }
}

