/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.compressor.zstd;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdDecompressCtx;
import edu.sysu.pmglab.ccf.compressor.IDecompressor;
import edu.sysu.pmglab.utils.Assert;

public final class ZstdDecompressor
extends IDecompressor {
    public static final String COMPRESSOR_NAME = "ZSTD";
    final ZstdDecompressCtx decompressor = new ZstdDecompressCtx();

    @Override
    public int getDecompressBound(byte[] src, int offset, int length) {
        long size = Zstd.decompressedSize(src, offset, length);
        Assert.valueRange((int)size, 0, 0x7FFFFFFD);
        return (int)size;
    }

    @Override
    public int decompress(byte[] src, int srcOffset, int srcLength, byte[] dst, int dstOffset) {
        return this.decompressor.decompressByteArray(dst, dstOffset, dst.length - dstOffset, src, srcOffset, srcLength);
    }

    @Override
    public void close() {
        this.decompressor.close();
    }
}

