/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.field;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.exception.InvalidFieldException;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IEditableFieldCollection;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.type.IFieldType;
import edu.sysu.pmglab.container.indexable.NamedSet;
import edu.sysu.pmglab.container.iterator.EmptyIterator;
import edu.sysu.pmglab.container.iterator.SingletonIterator;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

public final class FieldGroupMeta
implements IEditableFieldCollection {
    private final String group;
    private final NamedSet<FieldMeta> fields;
    private final AtomicBoolean modifiable = new AtomicBoolean(true);

    public FieldGroupMeta() {
        this(null);
    }

    public FieldGroupMeta(String group) {
        this(group, 4);
    }

    public FieldGroupMeta(String group, int initSize) {
        this.group = group == null || group.length() == 0 ? null : group;
        this.fields = new NamedSet(initSize);
    }

    public static FieldGroupMeta load(Bytes codec) {
        ByteStream reader = codec.toByteStream();
        FieldGroupMeta group = new FieldGroupMeta(reader.getString(StandardCharsets.UTF_8));
        while (reader.rRemaining() > 0) {
            group.addField(group.group, reader.getString(StandardCharsets.UTF_8), IFieldType.get(reader.getString(StandardCharsets.UTF_8)));
        }
        reader.close();
        return group.asUnmodifiable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldGroupMeta addField(FieldMeta field) {
        FieldGroupMeta fieldGroupMeta = this;
        synchronized (fieldGroupMeta) {
            if (!this.modifiable.get()) {
                throw new IllegalStateException("This object is immutable");
            }
            if (field == null) {
                return this;
            }
            if (!Objects.equals(field.groupName(), this.group)) {
                field = FieldMeta.of(this.group, field.simpleName(), field.type());
            }
            if (this.fields.contains(field)) {
                return this;
            }
            if (this.fields.contains(field.fullName())) {
                throw new InvalidFieldException("Duplicated field '" + field.fullName() + "' has an inconsistent field type");
            }
            if (this.group == null) {
                this.fields.adds(field, field.simpleName());
            } else {
                this.fields.adds(field, field.fullName(), field.simpleName());
            }
        }
        return this;
    }

    @Override
    public FieldGroupMeta addField(String name, IFieldType type) {
        return this.addField(FieldMeta.of(name, type));
    }

    @Override
    public FieldGroupMeta addField(String group, String name, IFieldType type) {
        IEditableFieldCollection.super.addField(group, name, type);
        return this;
    }

    @Override
    public FieldGroupMeta addFields(FieldMeta ... fields) {
        IEditableFieldCollection.super.addFields(fields);
        return this;
    }

    @Override
    public FieldGroupMeta addFields(Iterable<FieldMeta> fields) {
        IEditableFieldCollection.super.addFields(fields);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldGroupMeta clear() {
        FieldGroupMeta fieldGroupMeta = this;
        synchronized (fieldGroupMeta) {
            if (!this.modifiable.get()) {
                throw new IllegalStateException("This object is immutable");
            }
            if (this.numOfFields() > 0) {
                this.fields.clear();
            }
        }
        return this;
    }

    public String groupName() {
        return this.group;
    }

    public int hashCode() {
        return this.group.hashCode();
    }

    public FieldGroupMeta clone() {
        FieldGroupMeta clones = new FieldGroupMeta(this.group, this.numOfFields());
        for (FieldMeta field : this.fields) {
            if (this.group == null) {
                clones.fields.adds(field, field.simpleName());
                continue;
            }
            clones.fields.adds(field, field.fullName(), field.simpleName());
        }
        return clones;
    }

    public String toString() {
        if (this.numOfFields() == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(this.group == null ? "" : this.group + ": ");
        int l = this.numOfFields();
        for (int index = 0; index < l; ++index) {
            if (index > 0) {
                builder.append(", ");
            }
            FieldMeta field = this.getField(index);
            builder.append(field.simpleName()).append(" (").append(field.type().getName()).append(")");
        }
        return builder.toString();
    }

    @Override
    public IFieldCollection getAllFields() {
        return this;
    }

    @Override
    public Iterable<String> getAllFieldGroupNames() {
        return this.fields.size() > 0 ? () -> new SingletonIterator<String>(this.group) : EmptyIterator::INSTANCE;
    }

    @Override
    public boolean containsFieldGroup(String group) {
        if (group == null || group.length() == 0) {
            group = null;
        }
        return this.fields.size() > 0 && Objects.equals(this.group, group);
    }

    @Override
    public FieldMeta getField(int index) {
        return this.fields.valueOf((FieldMeta)index);
    }

    @Override
    public FieldGroupMeta getFieldGroup(String group) {
        if (group == null || group.length() == 0) {
            group = null;
        }
        if (this.fields.size() > 0 && Objects.equals(this.group, group)) {
            if (this.isModifiable()) {
                return this.clone().asUnmodifiable();
            }
            return this;
        }
        return null;
    }

    @Override
    public int numOfFields() {
        return this.fields.size();
    }

    @Override
    public int numOfFieldGroups() {
        return this.fields.size() == 0 ? 0 : 1;
    }

    @Override
    public int indexOfField(String name) {
        if (name == null || name.length() == 0) {
            return -1;
        }
        return this.fields.indexOf(name);
    }

    @Override
    public int indexOfField(String group, String name) {
        if (group == null || group.length() == 0) {
            group = null;
        }
        if (Objects.equals(this.group, group)) {
            return this.fields.indexOf(name);
        }
        return -1;
    }

    @Override
    public int indexOfField(FieldMeta field) {
        return this.fields.indexOf(field);
    }

    @Override
    public boolean isModifiable() {
        return this.modifiable.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldGroupMeta asUnmodifiable() {
        if (this.modifiable.get()) {
            FieldGroupMeta fieldGroupMeta = this;
            synchronized (fieldGroupMeta) {
                this.modifiable.set(false);
            }
        }
        return this;
    }

    public Bytes save() {
        ByteStream container = ByteStream.getThreadInstance();
        container.putString(this.group, StandardCharsets.UTF_8, true);
        for (FieldMeta field : this) {
            container.putString(field.simpleName(), StandardCharsets.UTF_8, true);
            container.putString(field.type().getName(), StandardCharsets.UTF_8, true);
        }
        return container.toBytes(true);
    }
}

