/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.field;

import edu.sysu.pmglab.ccf.field.FieldGroupMeta;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IEditableFieldCollection;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.type.IFieldType;
import edu.sysu.pmglab.container.indexable.NamedSet;
import gnu.trove.set.hash.THashSet;
import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public final class FieldGroupMetas
implements IEditableFieldCollection {
    private final AtomicBoolean modifiable = new AtomicBoolean(true);
    private final LinkedHashMap<String, FieldGroupMeta> groups;
    private final NamedSet<FieldMeta> fields = new NamedSet();

    public FieldGroupMetas() {
        this(4);
    }

    public FieldGroupMetas(int initialCapacity) {
        this.groups = new LinkedHashMap(initialCapacity);
    }

    public FieldGroupMetas(Iterable<FieldMeta> fields) {
        this(4);
        this.addFields((Iterable)fields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldGroupMetas addField(FieldMeta field) {
        FieldGroupMetas fieldGroupMetas = this;
        synchronized (fieldGroupMetas) {
            FieldGroupMeta group;
            if (!this.modifiable.get()) {
                throw new IllegalStateException("This object is immutable");
            }
            if (field == null) {
                return this;
            }
            if (!this.groups.containsKey(field.groupName())) {
                group = new FieldGroupMeta(field.groupName(), 4);
                this.groups.put(field.groupName(), group);
            } else {
                group = this.groups.get(field.groupName());
            }
            if (!group.containsField(field)) {
                group.addField(field);
                this.fields.adds(field, field.fullName());
            }
        }
        return this;
    }

    @Override
    public FieldGroupMetas addField(String name, IFieldType type) {
        IEditableFieldCollection.super.addField(name, type);
        return this;
    }

    @Override
    public FieldGroupMetas addField(String group, String name, IFieldType type) {
        IEditableFieldCollection.super.addField(group, name, type);
        return this;
    }

    @Override
    public FieldGroupMetas addFields(FieldMeta ... fields) {
        IEditableFieldCollection.super.addFields(fields);
        return this;
    }

    @Override
    public FieldGroupMetas addFields(Iterable<FieldMeta> fields) {
        IEditableFieldCollection.super.addFields(fields);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldGroupMetas clear() {
        FieldGroupMetas fieldGroupMetas = this;
        synchronized (fieldGroupMetas) {
            if (!this.modifiable.get()) {
                throw new IllegalStateException("This object is immutable");
            }
            if (this.numOfFields() > 0) {
                this.groups.clear();
                this.fields.clear();
            }
        }
        return this;
    }

    public FieldGroupMetas clone() {
        FieldGroupMetas clones = new FieldGroupMetas(this.groups.size());
        for (String groupName : this.groups.keySet()) {
            clones.addFields((Iterable)this.groups.get(groupName));
        }
        return clones;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Fields in FieldGroup (").append(this.numOfFields()).append(" in total):");
        for (FieldGroupMeta group : this.groups.values()) {
            builder.append("\n    ").append(group);
        }
        return builder.toString();
    }

    @Override
    public IFieldCollection getAllFields() {
        return this;
    }

    @Override
    public Iterable<String> getAllFieldGroupNames() {
        return this.groups.keySet();
    }

    @Override
    public boolean containsFieldGroup(String group) {
        if (group == null || group.length() == 0) {
            group = null;
        }
        return this.groups.containsKey(group);
    }

    @Override
    public FieldMeta getField(int index) {
        return this.fields.valueOf((FieldMeta)index);
    }

    @Override
    public FieldGroupMeta getFieldGroup(String group) {
        FieldGroupMeta groupMeta;
        if (group == null || group.length() == 0) {
            group = null;
        }
        if ((groupMeta = this.groups.get(group)) == null) {
            return null;
        }
        if (groupMeta.isModifiable()) {
            return groupMeta.clone().asUnmodifiable();
        }
        return groupMeta;
    }

    @Override
    public int numOfFields() {
        return this.fields.size();
    }

    @Override
    public int numOfFieldGroups() {
        return this.groups.size();
    }

    @Override
    public int indexOfField(String name) {
        return this.fields.indexOf(name);
    }

    @Override
    public int indexOfField(String group, String name) {
        if (group == null || group.length() == 0) {
            group = null;
        }
        if (this.groups.containsKey(group)) {
            if (group == null) {
                return this.fields.indexOf(name);
            }
            FieldGroupMeta g = this.groups.get(group);
            FieldMeta field = g.getField(group, name);
            if (field == null) {
                return -1;
            }
            return this.fields.indexOf(field);
        }
        return -1;
    }

    @Override
    public int indexOfField(FieldMeta field) {
        return this.fields.indexOf(field);
    }

    @Override
    public boolean isModifiable() {
        return this.modifiable.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IFieldCollection asUnmodifiable() {
        if (this.modifiable.get()) {
            FieldGroupMetas fieldGroupMetas = this;
            synchronized (fieldGroupMetas) {
                if (!this.modifiable.get()) {
                    return this;
                }
                this.fields.clear();
                THashSet<String> removed = new THashSet<String>(0);
                for (FieldGroupMeta fieldGroupMeta : this.groups.values()) {
                    if (fieldGroupMeta.numOfFields() != 0) continue;
                    removed.add(fieldGroupMeta.groupName());
                }
                if (removed.size() > 0) {
                    for (String string : removed) {
                        this.groups.remove(string);
                    }
                }
                removed.clear();
                if (this.groups.size() == 1) {
                    for (FieldGroupMeta fieldGroupMeta : this.groups.values()) {
                        fieldGroupMeta.asUnmodifiable();
                        for (FieldMeta field : fieldGroupMeta) {
                            this.fields.adds(field, field.fullName(), field.simpleName());
                        }
                    }
                } else {
                    for (FieldGroupMeta fieldGroupMeta : this.groups.values()) {
                        fieldGroupMeta.asUnmodifiable();
                        for (FieldMeta field : fieldGroupMeta) {
                            this.fields.adds(field, field.fullName());
                        }
                    }
                }
                this.modifiable.set(false);
            }
        }
        return this;
    }
}

