/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.field;

import edu.sysu.pmglab.ccf.exception.InvalidFieldException;
import edu.sysu.pmglab.ccf.field.FieldGroupMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.type.IFieldType;
import edu.sysu.pmglab.container.iterator.SingletonIterator;
import edu.sysu.pmglab.container.list.List;
import gnu.trove.map.hash.THashMap;
import java.util.Objects;

public final class FieldMeta
implements IFieldCollection {
    private static final THashMap<String, List<FieldMeta>> CACHE = new THashMap();
    private final String group;
    private final String simple;
    private final String full;
    private final IFieldType type;
    private final int hashCode;
    private FieldGroupMeta wrapper = null;

    private FieldMeta(String group, String simple, IFieldType type) {
        this.group = group == null || group.length() == 0 ? null : group;
        this.simple = simple;
        this.full = this.group == null ? this.simple : this.group + "@" + this.simple;
        this.type = type;
        this.hashCode = Objects.hashCode(this.full);
    }

    public static FieldMeta of(String full, IFieldType type) {
        if (full == null || full.length() == 0 || full.charAt(full.length() - 1) == '@') {
            throw new InvalidFieldException("Field names are defined using the format 'group@simple', where 'simple' must not be empty.");
        }
        int index = full.indexOf("@");
        if (index == -1) {
            return FieldMeta.of(null, full, type);
        }
        if (index == 0) {
            return FieldMeta.of(null, full.substring(1), type);
        }
        return FieldMeta.of(full.substring(0, index), full.substring(index + 1), type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FieldMeta of(String group, String simple, IFieldType type) {
        if (type == null) {
            throw new InvalidFieldException("Field type cannot be null");
        }
        if (simple == null || simple.length() == 0) {
            throw new InvalidFieldException("Field names are defined using the format 'group@simple', where 'simple' must not be empty.");
        }
        if (group == null || group.length() == 0) {
            group = null;
        } else if (group.indexOf(64) != -1) {
            group = group.replace('@', '_');
        }
        if (simple.indexOf(64) != -1) {
            simple = simple.replace('@', '_');
        }
        String full = group == null ? simple : group + "@" + simple;
        THashMap<String, List<FieldMeta>> tHashMap = CACHE;
        synchronized (tHashMap) {
            List<FieldMeta> fields = CACHE.get(full);
            if (fields == null) {
                fields = new List(1);
                CACHE.put(full, fields);
            } else {
                for (FieldMeta field : fields) {
                    if (field.type() != type) continue;
                    return field;
                }
            }
            FieldMeta field = new FieldMeta(group, simple, type);
            fields.add(field);
            return field;
        }
    }

    public IFieldType type() {
        return this.type;
    }

    public String simpleName() {
        return this.simple;
    }

    public String groupName() {
        return this.group;
    }

    public String fullName() {
        return this.full;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public FieldMeta clone() {
        return this;
    }

    public String toString() {
        return this.full + " (" + this.type + ")";
    }

    @Override
    public IFieldCollection getAllFields() {
        return this;
    }

    @Override
    public Iterable<String> getAllFieldGroupNames() {
        return () -> new SingletonIterator<String>(this.group);
    }

    @Override
    public boolean containsFieldGroup(String group) {
        if (group == null || group.length() == 0) {
            group = null;
        }
        return Objects.equals(this.group, group);
    }

    @Override
    public FieldMeta getField(int index) {
        if (index == 0) {
            return this;
        }
        throw new IndexOutOfBoundsException(String.valueOf(index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldGroupMeta getFieldGroup(String group) {
        if (group == null || group.length() == 0) {
            group = null;
        }
        if (Objects.equals(this.group, group)) {
            FieldMeta fieldMeta = this;
            synchronized (fieldMeta) {
                if (this.wrapper == null) {
                    this.wrapper = new FieldGroupMeta(this.group, 1).addField(this).asUnmodifiable();
                }
            }
            return this.wrapper;
        }
        return null;
    }

    @Override
    public int numOfFields() {
        return 1;
    }

    @Override
    public int numOfFieldGroups() {
        return 1;
    }

    @Override
    public int indexOfField(String name) {
        return Objects.equals(this.simple, name) || Objects.equals(this.full, name) ? 0 : -1;
    }

    @Override
    public int indexOfField(String group, String name) {
        if (group == null || group.length() == 0) {
            group = null;
        }
        if (Objects.equals(this.group, group) && Objects.equals(this.simple, name)) {
            return 0;
        }
        return -1;
    }

    @Override
    public int indexOfField(FieldMeta field) {
        return this == field ? 0 : -1;
    }
}

