/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.field;

import edu.sysu.pmglab.ccf.field.FieldGroupMeta;
import edu.sysu.pmglab.ccf.field.FieldGroupMetas;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IEditableFieldCollection;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.type.IFieldType;

public final class HybridFieldGroupMetas
implements IEditableFieldCollection {
    private final IFieldCollection mandatory;
    private final FieldGroupMetas supplementary = new FieldGroupMetas();
    private final FieldGroupMetas complete;

    public HybridFieldGroupMetas() {
        this.mandatory = IFieldCollection.EMPTY;
        this.complete = this.supplementary;
    }

    public HybridFieldGroupMetas(IFieldCollection mandatory) {
        if (mandatory == null || mandatory.numOfFields() == 0) {
            this.mandatory = IFieldCollection.EMPTY;
            this.complete = this.supplementary;
        } else if (!mandatory.isModifiable() && (mandatory instanceof FieldMeta || mandatory instanceof FieldGroupMeta || mandatory instanceof FieldGroupMetas || mandatory instanceof HybridFieldGroupMetas)) {
            this.mandatory = mandatory;
            this.complete = new FieldGroupMetas(this.mandatory);
        } else {
            this.mandatory = mandatory.numOfFields() == 1 ? mandatory.getField(0) : new FieldGroupMetas(mandatory).asUnmodifiable();
            this.complete = new FieldGroupMetas(this.mandatory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HybridFieldGroupMetas addField(FieldMeta field) {
        HybridFieldGroupMetas hybridFieldGroupMetas = this;
        synchronized (hybridFieldGroupMetas) {
            if (!this.isModifiable()) {
                throw new IllegalStateException("This object is immutable");
            }
            if (!this.complete.containsField(field)) {
                this.complete.addField(field);
                if (this.complete != this.supplementary) {
                    this.supplementary.addField(field);
                }
            }
        }
        return this;
    }

    @Override
    public HybridFieldGroupMetas addField(String name, IFieldType type) {
        IEditableFieldCollection.super.addField(name, type);
        return this;
    }

    @Override
    public HybridFieldGroupMetas addField(String group, String name, IFieldType type) {
        IEditableFieldCollection.super.addField(group, name, type);
        return this;
    }

    @Override
    public HybridFieldGroupMetas addFields(FieldMeta ... fields) {
        IEditableFieldCollection.super.addFields(fields);
        return this;
    }

    @Override
    public HybridFieldGroupMetas addFields(Iterable<FieldMeta> fields) {
        IEditableFieldCollection.super.addFields(fields);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HybridFieldGroupMetas clear() {
        HybridFieldGroupMetas hybridFieldGroupMetas = this;
        synchronized (hybridFieldGroupMetas) {
            if (!this.isModifiable()) {
                throw new IllegalStateException("This object is immutable");
            }
            if (this.supplementary.numOfFields() > 0) {
                this.supplementary.clear();
                this.complete.clear();
                if (this.mandatory.numOfFields() > 0) {
                    this.complete.addFields((Iterable)this.mandatory);
                }
            }
        }
        return this;
    }

    public HybridFieldGroupMetas clone() {
        HybridFieldGroupMetas clones = new HybridFieldGroupMetas(this.mandatory);
        for (FieldMeta field : this) {
            clones.addField(field);
        }
        return clones;
    }

    public String toString() {
        return this.complete.toString();
    }

    @Override
    public IFieldCollection getAllFields() {
        return this.complete;
    }

    @Override
    public Iterable<String> getAllFieldGroupNames() {
        return this.complete.getAllFieldGroupNames();
    }

    @Override
    public boolean containsFieldGroup(String group) {
        return this.complete.containsFieldGroup(group);
    }

    @Override
    public FieldMeta getField(int index) {
        return this.complete.getField(index);
    }

    @Override
    public FieldGroupMeta getFieldGroup(String group) {
        return this.complete.getFieldGroup(group);
    }

    @Override
    public int numOfFields() {
        return this.complete.numOfFields();
    }

    @Override
    public int numOfFieldGroups() {
        return this.complete.numOfFieldGroups();
    }

    @Override
    public int indexOfField(String name) {
        return this.complete.indexOfField(name);
    }

    @Override
    public int indexOfField(String group, String name) {
        return this.complete.indexOfField(group, name);
    }

    @Override
    public int indexOfField(FieldMeta field) {
        return this.complete.indexOfField(field);
    }

    @Override
    public boolean isModifiable() {
        return this.complete.isModifiable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IFieldCollection asUnmodifiable() {
        if (this.complete.isModifiable()) {
            HybridFieldGroupMetas hybridFieldGroupMetas = this;
            synchronized (hybridFieldGroupMetas) {
                if (!this.complete.isModifiable()) {
                    return this;
                }
                this.complete.asUnmodifiable();
                this.supplementary.asUnmodifiable();
            }
        }
        return this;
    }

    public IFieldCollection getAllMandatoryFields() {
        return this.mandatory;
    }

    public IFieldCollection getAllSupplementaryFields() {
        return this.supplementary;
    }
}

