/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.field;

import edu.sysu.pmglab.ccf.field.FieldGroupMeta;
import edu.sysu.pmglab.ccf.field.FieldGroupMetas;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IEditableFieldCollection;
import edu.sysu.pmglab.ccf.toolkit.filter.IFilter;
import edu.sysu.pmglab.ccf.type.IFieldType;
import edu.sysu.pmglab.container.iterator.EmptyIterator;
import edu.sysu.pmglab.container.iterator.FilterIterator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;

public interface IFieldCollection
extends Iterable<FieldMeta> {
    public static final IFieldCollection EMPTY = new IFieldCollection(){

        @Override
        public IFieldCollection getAllFields() {
            return this;
        }

        @Override
        public Iterable<String> getAllFieldGroupNames() {
            return EmptyIterator::INSTANCE;
        }

        @Override
        public boolean containsFieldGroup(String group) {
            return false;
        }

        @Override
        public FieldMeta getField(int index) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }

        @Override
        public FieldGroupMeta getFieldGroup(String group) {
            return null;
        }

        @Override
        public int numOfFields() {
            return 0;
        }

        @Override
        public int numOfFieldGroups() {
            return 0;
        }

        @Override
        public int indexOfField(String name) {
            return -1;
        }

        @Override
        public int indexOfField(String group, String name) {
            return -1;
        }

        @Override
        public int indexOfField(FieldMeta field) {
            return -1;
        }
    };

    public IFieldCollection getAllFields();

    default public <T> Iterable<T> apply(final Function<FieldMeta, T> applier, boolean removeNull) {
        final Iterator<FieldMeta> iter = this.iterator();
        if (removeNull) {
            return () -> new FilterIterator<Object>(() -> new Iterator<T>(){

                @Override
                public boolean hasNext() {
                    return iter.hasNext();
                }

                @Override
                public T next() {
                    return applier.apply(iter.next());
                }
            }, Objects::nonNull);
        }
        return () -> new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public T next() {
                return applier.apply(iter.next());
            }
        };
    }

    default public Iterable<String> getAllFieldGroupNames() {
        return this.getAllFields().getAllFieldGroupNames();
    }

    default public boolean containsFieldGroup(String group) {
        return this.getAllFields().containsFieldGroup(group);
    }

    default public FieldMeta getField(int index) {
        return this.getAllFields().getField(index);
    }

    default public FieldGroupMeta getFieldGroup(String group) {
        return this.getAllFields().getFieldGroup(group);
    }

    default public int numOfFields() {
        return this.getAllFields().numOfFields();
    }

    default public int numOfFieldGroups() {
        return this.getAllFields().numOfFieldGroups();
    }

    default public int indexOfField(String name) {
        return this.getAllFields().indexOfField(name);
    }

    default public int indexOfField(String group, String name) {
        return this.getAllFields().indexOfField(group, name);
    }

    default public int indexOfField(FieldMeta field) {
        return this.getAllFields().indexOfField(field);
    }

    default public int indexOfField(String name, IFieldType type) {
        int index = this.indexOfField(name);
        if (index == -1) {
            return -1;
        }
        if (type != null && this.getFieldType(index) == type) {
            return index;
        }
        return -1;
    }

    default public int indexOfField(String group, String name, IFieldType type) {
        int index = this.indexOfField(group, name);
        if (index == -1) {
            return -1;
        }
        if (type != null && this.getFieldType(index) == type) {
            return index;
        }
        return -1;
    }

    default public Iterator<FieldMeta> filter(IFilter<FieldMeta> rule) {
        return new FilterIterator<FieldMeta>(this, rule);
    }

    default public Iterator<FieldMeta> filterByGroupName(IFilter<String> rule) {
        return new FilterIterator<FieldMeta>(this, rule == null ? null : field -> rule.filter(field.groupName()));
    }

    default public Iterator<FieldMeta> filterBySimpleName(IFilter<String> rule) {
        return new FilterIterator<FieldMeta>(this, rule == null ? null : field -> rule.filter(field.simpleName()));
    }

    default public Iterator<FieldMeta> filterByFullName(IFilter<String> rule) {
        return new FilterIterator<FieldMeta>(this, rule == null ? null : field -> rule.filter(field.fullName()));
    }

    default public Iterator<FieldMeta> filterByType(IFilter<IFieldType> rule) {
        return new FilterIterator<FieldMeta>(this, rule == null ? null : field -> rule.filter(field.type()));
    }

    default public FieldMeta getField(String name) {
        int index = this.indexOfField(name);
        if (index == -1) {
            return null;
        }
        return this.getField(index);
    }

    default public FieldMeta getField(String group, String name) {
        int index = this.indexOfField(group, name);
        if (index == -1) {
            return null;
        }
        return this.getField(index);
    }

    default public FieldMeta getField(String name, IFieldType type) {
        int index = this.indexOfField(name, type);
        if (index == -1) {
            return null;
        }
        return this.getField(index);
    }

    default public FieldMeta getField(String group, String name, IFieldType type) {
        int index = this.indexOfField(group, name, type);
        if (index == -1) {
            return null;
        }
        return this.getField(index);
    }

    default public IFieldCollection subsetFields(String ... names) {
        IEditableFieldCollection collection;
        if (names == null || names.length == 0 || this.numOfFields() == 0) {
            return EMPTY;
        }
        if (this.numOfFields() == 1 || names.length == 1) {
            for (String name : names) {
                FieldMeta field = this.getField(name);
                if (field == null) continue;
                return field;
            }
            return EMPTY;
        }
        if (this.numOfFieldGroups() == 1) {
            collection = new FieldGroupMeta(this.getField(0).groupName());
            for (String name : names) {
                collection.addField(this.getField(name));
            }
        } else {
            collection = new FieldGroupMetas();
            for (String name : names) {
                collection.addField(this.getField(name));
            }
            if (collection.numOfFieldGroups() == 1 && collection.numOfFields() > 0) {
                collection = collection.getFieldGroup(collection.getField(0).groupName());
            }
        }
        if (collection == null || collection.numOfFields() == 0) {
            return EMPTY;
        }
        if (collection.numOfFields() == 1) {
            return collection.getField(0);
        }
        if (!this.isModifiable() && this.equals(collection)) {
            return this;
        }
        return collection.asUnmodifiable();
    }

    default public IFieldCollection subsetFields(Iterable<String> names) {
        IEditableFieldCollection collection;
        if (names == null || this.numOfFields() == 0) {
            return EMPTY;
        }
        if (this.numOfFields() == 1) {
            for (String name : names) {
                FieldMeta field = this.getField(name);
                if (field == null) continue;
                return field;
            }
            return EMPTY;
        }
        if (this.numOfFieldGroups() == 1) {
            collection = new FieldGroupMeta(this.getField(0).groupName());
            for (String name : names) {
                collection.addField(this.getField(name));
            }
        } else {
            collection = new FieldGroupMetas();
            for (String name : names) {
                collection.addField(this.getField(name));
            }
            if (collection.numOfFieldGroups() == 1 && collection.numOfFields() > 0) {
                collection = collection.getFieldGroup(collection.getField(0).groupName());
            }
        }
        if (collection == null || collection.numOfFields() == 0) {
            return EMPTY;
        }
        if (collection.numOfFields() == 1) {
            return collection.getField(0);
        }
        if (!this.isModifiable() && this.equals(collection)) {
            return this;
        }
        return collection.asUnmodifiable();
    }

    default public IFieldCollection subsetFieldsExcludes(IFieldCollection excludes) {
        IEditableFieldCollection collection;
        if (this.numOfFields() == 0) {
            return EMPTY;
        }
        if (excludes == null || excludes.numOfFields() == 0) {
            return this;
        }
        if (this.numOfFieldGroups() == 1) {
            collection = new FieldGroupMeta(this.getField(0).groupName());
            for (FieldMeta field : this) {
                if (excludes.containsField(field)) continue;
                collection.addField(field);
            }
        } else {
            collection = new FieldGroupMetas();
            for (FieldMeta field : this) {
                if (excludes.containsField(field)) continue;
                collection.addField(field);
            }
            if (collection.numOfFieldGroups() == 1 && collection.numOfFields() > 0) {
                collection = collection.getFieldGroup(collection.getField(0).groupName());
            }
        }
        if (collection == null || collection.numOfFields() == 0) {
            return EMPTY;
        }
        if (collection.numOfFields() == 1) {
            return collection.getField(0);
        }
        if (!this.isModifiable() && collection.numOfFields() == this.numOfFields()) {
            return this;
        }
        return collection.asUnmodifiable();
    }

    default public IFieldCollection intersectFields(IFieldCollection collection) {
        IEditableFieldCollection container;
        if (collection == null || collection.numOfFields() == 0 || this.numOfFields() == 0) {
            return EMPTY;
        }
        if (collection == this) {
            return this;
        }
        if (this.numOfFieldGroups() == 1) {
            container = new FieldGroupMeta(this.getField(0).groupName());
            for (FieldMeta field : this) {
                if (!collection.containsField(field)) continue;
                container.addField(field);
            }
        } else if (collection.numOfFieldGroups() == 1) {
            container = new FieldGroupMeta(collection.getField(0).groupName());
            for (FieldMeta field : this) {
                if (!collection.containsField(field)) continue;
                container.addField(field);
            }
        } else {
            container = new FieldGroupMetas();
            for (FieldMeta field : this) {
                if (!collection.containsField(field)) continue;
                container.addField(field);
            }
            if (container.numOfFieldGroups() == 1 && container.numOfFields() > 0) {
                container = container.getFieldGroup(container.getField(0).groupName());
            }
        }
        if (container == null || container.numOfFields() == 0) {
            return EMPTY;
        }
        if (container.numOfFields() == 1) {
            return container.getField(0);
        }
        if (!this.isModifiable() && container.numOfFields() == this.numOfFields()) {
            return this;
        }
        if (!collection.isModifiable() && container.numOfFields() == collection.numOfFields()) {
            return collection;
        }
        return container.asUnmodifiable();
    }

    default public IFieldType getFieldType(String name) {
        FieldMeta field = this.getField(name);
        return field == null ? null : field.type();
    }

    default public IFieldType getFieldType(String group, String name) {
        FieldMeta field = this.getField(group, name);
        return field == null ? null : field.type();
    }

    default public IFieldType getFieldType(int index) {
        return this.getField(index).type();
    }

    default public boolean containsField(String name) {
        return this.indexOfField(name) != -1;
    }

    default public boolean containsField(String name, IFieldType type) {
        return this.indexOfField(name, type) != -1;
    }

    default public boolean containsField(String group, String name) {
        return this.indexOfField(group, name) != -1;
    }

    default public boolean containsField(String group, String name, IFieldType type) {
        return this.indexOfField(group, name, type) != -1;
    }

    default public boolean containsField(FieldMeta field) {
        return this.indexOfField(field) != -1;
    }

    default public Iterable<FieldGroupMeta> getAllFieldGroups() {
        return () -> new Iterator<FieldGroupMeta>(){
            final Iterator groups;
            {
                this.groups = IFieldCollection.this.getAllFieldGroupNames().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.groups.hasNext();
            }

            @Override
            public FieldGroupMeta next() {
                if (this.groups.hasNext()) {
                    return IFieldCollection.this.getFieldGroup((String)this.groups.next());
                }
                throw new NoSuchElementException();
            }
        };
    }

    default public Iterable<String> getAllFieldNames() {
        return () -> {
            final int num = this.numOfFields();
            return new Iterator<String>(){
                int index = 0;

                @Override
                public boolean hasNext() {
                    return this.index < num;
                }

                @Override
                public String next() {
                    if (this.index < num) {
                        return IFieldCollection.this.getField(this.index++).fullName();
                    }
                    throw new NoSuchElementException();
                }
            };
        };
    }

    default public boolean equals(IFieldCollection others) {
        if (others == null) {
            return false;
        }
        if (this == others) {
            return true;
        }
        if (this.numOfFields() == 0 && others.numOfFields() == 0) {
            return true;
        }
        if (this.numOfFields() != others.numOfFields()) {
            return false;
        }
        int l = this.numOfFields();
        for (int fieldIndex = 0; fieldIndex < l; ++fieldIndex) {
            if (this.getField(fieldIndex) == others.getField(fieldIndex)) continue;
            return false;
        }
        return true;
    }

    @Override
    default public Iterator<FieldMeta> iterator() {
        final int num = this.numOfFields();
        return new Iterator<FieldMeta>(){
            int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < num;
            }

            @Override
            public FieldMeta next() {
                if (this.index < num) {
                    return IFieldCollection.this.getField(this.index++);
                }
                throw new NoSuchElementException();
            }
        };
    }

    default public boolean isModifiable() {
        return false;
    }

    default public IFieldCollection asUnmodifiable() {
        return this;
    }
}

