/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.filter;

import edu.sysu.pmglab.ccf.CCFReader;
import edu.sysu.pmglab.ccf.IReaderOption;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.filter.FoundAction;
import edu.sysu.pmglab.ccf.filter.NotFoundAction;
import edu.sysu.pmglab.ccf.record.BoxRecord;
import edu.sysu.pmglab.ccf.toolkit.filter.IFilter;
import edu.sysu.pmglab.ccf.toolkit.filter.ILongFilter;
import edu.sysu.pmglab.ccf.type.Box;
import edu.sysu.pmglab.container.interval.LongInterval;
import edu.sysu.pmglab.container.list.List;
import java.io.IOException;

public class CCFFilter {
    protected final CCFReader reader;
    protected final BoxRecord record;
    protected final List<ILongFilter> pointers = new List();
    protected final List<IFilter<BoxRecord>> records = new List();

    public CCFFilter(IReaderOption<?> option) throws IOException {
        this.reader = new CCFReader(option);
        this.record = this.reader.getRecord();
    }

    public IFieldCollection getAllFields() {
        return this.reader.getAllFields();
    }

    public IReaderOption<?> getReaderOption() {
        return this.reader.getReaderOption();
    }

    public LongInterval getPointerRange() {
        return this.reader.available();
    }

    public CCFFilter limit(long start, long end) {
        this.reader.limit(start, end);
        return this;
    }

    public CCFFilter limit(LongInterval interval) {
        this.reader.limit(interval);
        return this;
    }

    public CCFFilter addPointerFilter(ILongFilter filter) {
        if (filter != null) {
            this.pointers.add(filter);
        }
        return this;
    }

    public CCFFilter addRecordFilter(IFilter<BoxRecord> filter) {
        if (filter != null) {
            this.records.add(filter);
        }
        return this;
    }

    public <V extends Box<?, ?>> CCFFilter addValueFilter(String field, IFilter<V> filter) {
        if (filter != null) {
            FieldMeta f = this.reader.getAllFields().getField(field);
            this.records.add(record -> {
                Object box = record.getBox(f);
                return filter.filter(box);
            });
        }
        return this;
    }

    public <V extends Box<?, ?>> CCFFilter addValueFilter(FieldMeta field, IFilter<V> filter) {
        if (filter != null) {
            this.records.add(record -> {
                Object box = record.getBox(field);
                return filter.filter(box);
            });
        }
        return this;
    }

    public CCFFilter seek(long pointer) throws IOException {
        this.reader.seek(pointer);
        return this;
    }

    public long tell() {
        return this.reader.tell();
    }

    public long filter() throws IOException {
        return this.filter(FoundAction.MOVE_NEXT, NotFoundAction.MOVE_END);
    }

    public long filter(FoundAction foundAction, NotFoundAction notFoundAction) throws IOException {
        if (foundAction == null || notFoundAction == null) {
            throw new NullPointerException();
        }
        long mark = this.reader.tell();
        long pointer = this.search();
        if (pointer == -1L) {
            if (notFoundAction == NotFoundAction.KEEP) {
                this.reader.seek(mark);
            } else if (notFoundAction == NotFoundAction.MOVE_END) {
                this.reader.seek(Long.MAX_VALUE);
            } else if (notFoundAction != NotFoundAction.MOVE_TO_TRY) {
                throw new NullPointerException();
            }
        } else if (foundAction == FoundAction.KEEP) {
            this.reader.seek(mark);
        } else if (foundAction == FoundAction.MOVE_TO) {
            this.reader.seek(pointer);
        } else if (foundAction == FoundAction.MOVE_NEXT) {
            this.reader.seek(pointer + 1L);
        } else if (foundAction == FoundAction.MOVE_END) {
            this.reader.seek(Long.MAX_VALUE);
        } else {
            throw new NullPointerException();
        }
        return pointer;
    }

    private long search() throws IOException {
        if (!this.reader.hasNext()) {
            return -1L;
        }
        if (this.pointers.size() == 0 && this.records.size() == 0) {
            return this.reader.tell();
        }
        if (this.pointers.size() == 0) {
            block0: while (this.reader.read(this.record)) {
                for (IFilter<BoxRecord> filter : this.records) {
                    if (filter.filter(this.record)) continue;
                    continue block0;
                }
                return this.reader.tell() - 1L;
            }
            return -1L;
        }
        if (this.records.size() == 0) {
            block2: for (long pointer = this.reader.tell(); pointer < this.reader.available().end(); ++pointer) {
                for (ILongFilter iLongFilter : this.pointers) {
                    if (iLongFilter.filter(pointer)) continue;
                    continue block2;
                }
                return pointer;
            }
            return -1L;
        }
        block4: for (long pointer = this.reader.tell(); pointer < this.reader.available().end(); ++pointer) {
            for (ILongFilter iLongFilter : this.pointers) {
                if (iLongFilter.filter(pointer)) continue;
                continue block4;
            }
            this.reader.seek(pointer);
            this.reader.read(this.record);
            for (IFilter iFilter : this.records) {
                if (iFilter.filter(this.record)) continue;
                continue block4;
            }
            return pointer;
        }
        return -1L;
    }

    public CCFFilter reset() {
        this.pointers.clear();
        this.records.clear();
        this.reader.clearLimit();
        return this;
    }

    public CCFFilter close() throws IOException {
        this.pointers.clear();
        this.records.clear();
        this.reader.close();
        this.record.clear();
        return this;
    }
}

