/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.header;

import edu.sysu.pmglab.utils.Assert;

public final class CCFHeader
implements Comparable<CCFHeader> {
    public static final CCFHeader FAKE_BLOCK = new CCFHeader();
    final long pointer;
    final int length;
    final int records;
    final long startIndex;
    final long endIndex;

    private CCFHeader() {
        this.pointer = 0L;
        this.length = 0;
        this.records = 0;
        this.startIndex = -1L;
        this.endIndex = -1L;
    }

    public CCFHeader(long pointer, int length, int records, long minRecordIndex, long maxRecordIndex) {
        Assert.that(pointer >= 0L);
        Assert.that(minRecordIndex >= 0L);
        Assert.that(maxRecordIndex >= 0L);
        if (minRecordIndex > maxRecordIndex) {
            throw new IllegalArgumentException("start > end");
        }
        this.pointer = pointer;
        this.length = length;
        this.records = records;
        this.startIndex = minRecordIndex;
        this.endIndex = maxRecordIndex;
    }

    public boolean contains(long recordIndex) {
        return this.startIndex <= recordIndex && this.endIndex >= recordIndex;
    }

    public long tell() {
        return this.pointer;
    }

    public int length() {
        return this.length;
    }

    public int numOfRecords() {
        return this.records;
    }

    public long getMinRecordIndex() {
        return this.startIndex;
    }

    public long getMaxRecordIndex() {
        return this.endIndex;
    }

    public boolean isFakeBlock() {
        return this == FAKE_BLOCK;
    }

    @Override
    public int compareTo(CCFHeader o) {
        return Long.compare(this.startIndex, o.startIndex);
    }
}

