/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.header;

import edu.sysu.pmglab.ccf.exception.CCFComponentException;
import edu.sysu.pmglab.ccf.field.FieldGroupMeta;
import edu.sysu.pmglab.ccf.header.CCFHeader;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.utils.ValueUtils;
import java.util.Iterator;

public final class CCFHeaders
implements Iterable<CCFHeader> {
    final FieldGroupMeta fields;
    final List<CCFHeader> blocks;

    public CCFHeaders(FieldGroupMeta fields, List<CCFHeader> blocks) {
        this.fields = fields.asUnmodifiable();
        this.blocks = blocks;
    }

    public CCFHeader getBlock(int blockIndex) {
        return blockIndex == -1 ? CCFHeader.FAKE_BLOCK : this.blocks.get(blockIndex);
    }

    public String getFieldGroupName() {
        return this.fields.groupName();
    }

    public FieldGroupMeta getAllFields() {
        return this.fields;
    }

    public int numOfFields() {
        return this.fields.numOfFields();
    }

    public int numOfBlocks() {
        return this.blocks.size();
    }

    public long numOfRecords() {
        long recordNums = 0L;
        for (CCFHeader block : this.blocks) {
            recordNums += (long)block.numOfRecords();
        }
        return recordNums;
    }

    public int getBlockIndexByRecordIndex(long recordIndex, int currentBlockIndex) {
        int end;
        int start;
        if (currentBlockIndex == -1) {
            start = 0;
            end = this.blocks.size() - 1;
        } else if (this.blocks.get(currentBlockIndex).getMinRecordIndex() > recordIndex) {
            start = 0;
            end = currentBlockIndex - 1;
        } else if (this.blocks.get(currentBlockIndex).getMaxRecordIndex() < recordIndex) {
            start = currentBlockIndex + 1;
            end = this.blocks.size() - 1;
        } else {
            return currentBlockIndex;
        }
        int middle = ValueUtils.valueOf((int)(recordIndex / (long)this.blocks.get(0).numOfRecords()), start, end);
        while (start <= end) {
            CCFHeader middleBlock = this.blocks.get(middle);
            if (middleBlock.getMinRecordIndex() > recordIndex) {
                end = middle - 1;
                middle = (start + end) / 2;
                continue;
            }
            if (middleBlock.getMaxRecordIndex() < recordIndex) {
                start = middle + 1;
                middle = (start + end) / 2;
                continue;
            }
            return middle;
        }
        throw new CCFComponentException("Unable to find the block with index " + recordIndex + " in the field group " + this.fields.groupName());
    }

    @Override
    public Iterator<CCFHeader> iterator() {
        return this.blocks.iterator();
    }
}

