/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.indexer.generics;

import edu.sysu.pmglab.container.interval.Interval;
import edu.sysu.pmglab.container.interval.LongInterval;
import edu.sysu.pmglab.container.rangelist.VarInt64RangeList;
import edu.sysu.pmglab.utils.ValueUtils;
import gnu.trove.iterator.TLongIterator;
import java.util.Comparator;

public class Bucket<V extends Comparable<V>>
implements Comparable<Bucket<V>> {
    public static final Comparator<Bucket<?>> POINTER_COMPARATOR = Comparator.comparingLong(o -> o.minPointer);
    public static final Comparator<Bucket> VALUE_COMPARATOR = Bucket::compareTo;
    private final VarInt64RangeList pointers;
    long count = 0L;
    V minValue = null;
    V maxValue = null;
    long minPointer = -1L;
    long maxPointer = -1L;
    boolean ordered = true;

    Bucket() {
        this(true);
    }

    Bucket(boolean recordedPointer) {
        this.pointers = recordedPointer ? new VarInt64RangeList() : null;
    }

    Bucket(long count, V minValue, V maxValue, long minPointer, long maxPointer, boolean ordered) {
        this.count = count;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.minPointer = minPointer;
        this.maxPointer = maxPointer;
        this.ordered = ordered;
        this.pointers = this.isCompact() ? new VarInt64RangeList().addInterval(new LongInterval(this.minPointer, this.maxPointer)) : null;
    }

    public Bucket<V> update(V value, long pointer) {
        if (pointer < 0L) {
            throw new IllegalArgumentException("pointer < 0");
        }
        if (value == null) {
            throw new IllegalArgumentException("build indexer for null value");
        }
        if (this.pointers != null) {
            this.pointers.add(pointer);
        }
        if (this.count == 0L) {
            this.minValue = value;
            this.maxValue = value;
            this.minPointer = pointer;
            this.maxPointer = pointer;
            this.ordered = true;
        } else if (this.ordered) {
            if (value.compareTo(this.maxValue) >= 0) {
                if (pointer >= this.maxPointer) {
                    this.maxValue = value;
                    this.maxPointer = pointer;
                } else {
                    this.maxValue = value;
                    if (pointer < this.minPointer) {
                        this.minPointer = pointer;
                    }
                    this.ordered = false;
                }
            } else if (value.compareTo(this.minValue) <= 0) {
                if (pointer <= this.minPointer) {
                    this.minValue = value;
                    this.minPointer = pointer;
                } else {
                    this.minValue = value;
                    if (pointer > this.maxPointer) {
                        this.maxPointer = pointer;
                    }
                    this.ordered = false;
                }
            } else {
                if (pointer > this.maxPointer) {
                    this.maxPointer = pointer;
                } else if (pointer < this.minPointer) {
                    this.minPointer = pointer;
                }
                this.ordered = false;
            }
        } else {
            if (value.compareTo(this.maxValue) > 0) {
                this.maxValue = value;
            } else if (value.compareTo(this.minValue) < 0) {
                this.minValue = value;
            }
            if (pointer > this.maxPointer) {
                this.maxPointer = pointer;
            } else if (pointer < this.minPointer) {
                this.minPointer = pointer;
            }
        }
        ++this.count;
        return this;
    }

    public Bucket<V> update(Bucket<V> bucket) {
        if (bucket == null || bucket.getCount() == 0L) {
            return this;
        }
        if (this.count == 0L) {
            this.count = bucket.count;
            this.maxValue = bucket.maxValue;
            this.minValue = bucket.minValue;
            this.maxPointer = bucket.maxPointer;
            this.minPointer = bucket.minPointer;
            this.ordered = bucket.ordered;
            if (this.pointers != null) {
                this.pointers.adds(bucket.pointers);
            }
            return this;
        }
        if (this.isOrdered() && bucket.isOrdered()) {
            if (this.maxPointer <= bucket.minPointer && this.maxValue.compareTo(bucket.minValue) <= 0) {
                this.count += bucket.count;
                this.maxPointer = bucket.maxPointer;
                this.maxValue = bucket.maxValue;
                if (this.pointers != null) {
                    this.pointers.adds(bucket.pointers);
                }
                return this;
            }
            if (bucket.maxPointer <= this.minPointer && bucket.maxValue.compareTo(this.minValue) <= 0) {
                this.count += bucket.count;
                this.minPointer = bucket.minPointer;
                this.minValue = bucket.minValue;
                if (this.pointers != null) {
                    VarInt64RangeList copy = new VarInt64RangeList().adds(bucket.pointers);
                    copy.adds(this.pointers);
                    this.pointers.clear();
                    this.pointers.adds(copy);
                }
                return this;
            }
        }
        this.count += bucket.count;
        this.maxValue = this.maxValue.compareTo(bucket.maxValue) >= 0 ? this.maxValue : bucket.maxValue;
        this.minValue = this.minValue.compareTo(bucket.minValue) < 0 ? this.minValue : bucket.minValue;
        this.maxPointer = Math.max(this.maxPointer, bucket.maxPointer);
        this.minPointer = Math.min(this.minPointer, bucket.minPointer);
        this.ordered = false;
        if (this.pointers != null) {
            this.pointers.adds(bucket.pointers);
        }
        return this;
    }

    public long getCount() {
        return this.count;
    }

    public V getMinValue() {
        if (this.count == 0L) {
            throw new IllegalStateException("Empty bucket");
        }
        return this.minValue;
    }

    public V getMaxValue() {
        if (this.count == 0L) {
            throw new IllegalStateException("Empty bucket");
        }
        return this.maxValue;
    }

    public Interval<V> getValueRange() {
        return new Interval<V>(this.getMinValue(), this.getMaxValue());
    }

    public long getMinPointer() {
        if (this.count == 0L) {
            throw new IllegalStateException("Empty bucket");
        }
        return this.minPointer;
    }

    public long getMaxPointer() {
        if (this.count == 0L) {
            throw new IllegalStateException("Empty bucket");
        }
        return this.maxPointer;
    }

    public LongInterval getRecordIndexRange() {
        return this.getCount() > 0L ? new LongInterval(this.getMinPointer(), this.getMaxPointer() + 1L) : null;
    }

    public boolean contains(V value) {
        if (value == null) {
            throw new IllegalArgumentException("null value");
        }
        if (this.getCount() == 0L) {
            return false;
        }
        if (this.getCount() == 1L) {
            return this.getMinValue().compareTo(value) == 0;
        }
        if (this.getCount() == 2L) {
            return this.getMinValue().compareTo(value) == 0 || this.getMaxValue().compareTo(value) == 0;
        }
        return this.getMinValue().compareTo(value) <= 0 && this.getMaxValue().compareTo(value) >= 0;
    }

    public boolean contains(V minValue, V maxValue) {
        if (minValue == null || maxValue == null) {
            throw new IllegalArgumentException("null endpoints");
        }
        if (this.getCount() == 0L) {
            return false;
        }
        if (minValue.compareTo(maxValue) > 0) {
            return false;
        }
        return this.getMinValue().compareTo(minValue) <= 0 && this.getMaxValue().compareTo(maxValue) >= 0;
    }

    public boolean overlaps(V minValue, V maxValue) {
        if (minValue == null || maxValue == null) {
            throw new IllegalArgumentException("null endpoints");
        }
        if (this.getCount() == 0L) {
            return false;
        }
        if (minValue.compareTo(maxValue) > 0) {
            return false;
        }
        return ValueUtils.intersect(minValue, maxValue, this.getMinValue(), this.getMaxValue());
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public boolean isCompact() {
        if (this.getCount() == 0L) {
            return true;
        }
        return this.getMaxPointer() - this.getMinPointer() == this.getCount() - 1L;
    }

    public Bucket<V> asUnmodifiable() {
        return new Bucket<V>(this.count, (Comparable)this.minValue, (Comparable)this.maxValue, this.minPointer, this.maxPointer, this.ordered){

            @Override
            public Bucket<V> update(V value, long pointer) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Bucket<V> update(Bucket<V> bucket) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Bucket<V> asUnmodifiable() {
                return this;
            }
        };
    }

    @Override
    public int compareTo(Bucket<V> o) {
        int status = this.getMinValue().compareTo(o.getMinValue());
        if (status == 0 && (status = this.getMaxValue().compareTo(o.getMaxValue())) == 0 && (status = Long.compare(this.getMinPointer(), o.getMaxPointer())) == 0 && (status = Long.compare(this.getMaxPointer(), o.getMaxPointer())) == 0) {
            status = Long.compare(this.getCount(), o.getCount());
        }
        return status;
    }

    public String toString() {
        return this.getCount() + " records in total, valueRange=[" + this.getMinValue() + ", " + this.getMaxValue() + "], pointerRange=[" + this.getMinPointer() + ", " + this.getMaxPointer() + "]";
    }

    public TLongIterator iterator() {
        if (this.pointers == null) {
            throw new IllegalStateException();
        }
        this.pointers.sort();
        return this.pointers.iterator();
    }

    public void destroy() {
        this.pointers.clear();
        this.count = 0L;
        this.minValue = null;
        this.maxValue = null;
        this.minPointer = -1L;
        this.maxPointer = -1L;
        this.ordered = true;
    }
}

