/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.indexer.generics;

import edu.sysu.pmglab.ccf.indexer.generics.Bucket;
import edu.sysu.pmglab.ccf.indexer.generics.BucketFlusher;
import edu.sysu.pmglab.ccf.indexer.generics.RefinedBuckets;
import edu.sysu.pmglab.container.list.List;
import java.util.Iterator;

public class DynamicCrudeBuckets<V extends Comparable<V>>
implements Iterable<Bucket<V>> {
    final List<Bucket<V>> buckets;
    final BucketFlusher<V> flusher;
    private Bucket<V> activeBucket = new Bucket(false);

    public DynamicCrudeBuckets(BucketFlusher<V> flusher) {
        this.flusher = flusher == null ? (bucket, value, pointer) -> bucket.getCount() >= 4096L : flusher;
        this.buckets = new List();
    }

    public RefinedBuckets<V> refined() {
        return new RefinedBuckets<V>(this.buckets);
    }

    public DynamicCrudeBuckets<V> update(V value, long pointer) {
        if (this.activeBucket.getCount() == 0L) {
            this.activeBucket.update(value, pointer);
            this.buckets.add(this.activeBucket);
        } else {
            if (this.flusher.flush(this.activeBucket, value, pointer)) {
                this.activeBucket = new Bucket();
                this.buckets.add(this.activeBucket);
            }
            this.activeBucket.update(value, pointer);
        }
        return this;
    }

    public DynamicCrudeBuckets<V> update(DynamicCrudeBuckets<V> crudeBucket) {
        for (int bucketIndex = 0; bucketIndex < crudeBucket.numOfBuckets(); ++bucketIndex) {
            Bucket<V> otherBucket = crudeBucket.getBucket(bucketIndex);
            if (otherBucket.getCount() <= 0L) continue;
            this.buckets.add(otherBucket);
        }
        return this;
    }

    public Bucket<V> getBucket(int index) {
        return this.buckets.get(index);
    }

    public int numOfBuckets() {
        return this.buckets.size();
    }

    @Override
    public Iterator<Bucket<V>> iterator() {
        return this.refined().iterator();
    }
}

