/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.indexer.generics;

import edu.sysu.pmglab.ccf.indexer.generics.Bucket;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.objectpool.LinkedObjectPool;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

public class FixedCrudeBuckets<V extends Comparable<V>> {
    final ToLongFunction<V> bucketBuilder;
    final LinkedObjectPool<Bucket<V>> buckets = new LinkedObjectPool<Bucket>(() -> new Bucket(true)).require(262144);

    public FixedCrudeBuckets(ToIntFunction<V> builder) {
        this.bucketBuilder = builder == null ? v -> 0L : builder::applyAsInt;
    }

    public List<Bucket<V>> refined(int minRefinedBucketSize, int maxRefinedBucketSize) {
        List<Bucket<V>> refinedBuckets = new List<Bucket<V>>();
        Bucket<V> refinedBucket = new Bucket<V>(true);
        for (int bucketIndex = 0; bucketIndex < this.buckets.size(); ++bucketIndex) {
            Bucket<V> bucket;
            Bucket<V> bucket2 = bucket = this.buckets.isInit(bucketIndex) ? this.buckets.fastGet(bucketIndex) : null;
            if (bucket == null || bucket.getCount() <= 0L) continue;
            if (refinedBucket.getCount() > 0L && refinedBucket.isCompact()) {
                if (bucket.isCompact() && (refinedBucket.getMaxPointer() + 1L == bucket.getMinPointer() || refinedBucket.getMinPointer() == bucket.getMaxPointer() + 1L)) {
                    refinedBucket.update(bucket);
                } else {
                    refinedBuckets.add(refinedBucket);
                    refinedBucket = new Bucket(true);
                    refinedBucket.update(bucket);
                }
            } else {
                refinedBucket.update(bucket);
            }
            if (refinedBucket.getCount() >= (long)maxRefinedBucketSize) {
                refinedBuckets.add(refinedBucket);
                refinedBucket = new Bucket(true);
            }
            bucket.destroy();
        }
        if (refinedBucket.getCount() > 0L) {
            refinedBuckets.add(refinedBucket);
        }
        return refinedBuckets;
    }

    public FixedCrudeBuckets<V> update(V value, long pointer) {
        long code = this.bucketBuilder.applyAsLong(value) - Integer.MIN_VALUE;
        int bucketIndex = (int)(code >>> 14);
        Bucket<V> bucket = this.buckets.get(bucketIndex);
        bucket.update(value, pointer);
        return this;
    }

    public FixedCrudeBuckets<V> update(FixedCrudeBuckets<V> crudeBucket) {
        for (int bucketIndex = 0; bucketIndex < this.buckets.size(); ++bucketIndex) {
            Bucket<V> otherBucket = crudeBucket.buckets.isInit(bucketIndex) ? crudeBucket.buckets.fastGet(bucketIndex) : null;
            if (otherBucket == null) continue;
            Bucket<V> bucket = this.buckets.get(bucketIndex);
            bucket.update(otherBucket);
        }
        return this;
    }

    public Bucket<V> getBucket(int index) {
        return this.buckets.get(index);
    }

    public int numOfBuckets() {
        return this.buckets.size();
    }

    public long getCount() {
        long count = 0L;
        for (Bucket<V> bucket : this.buckets) {
            count += bucket.getCount();
        }
        return count;
    }
}

