/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.indexer.generics;

import edu.sysu.pmglab.ccf.indexer.generics.Bucket;
import edu.sysu.pmglab.container.interval.Interval;
import edu.sysu.pmglab.container.interval.LongInterval;
import edu.sysu.pmglab.container.intervaltree.generics.IntervalTree;
import edu.sysu.pmglab.container.list.List;
import java.util.Iterator;
import java.util.Objects;

public class RefinedBuckets<V extends Comparable<V>>
implements Iterable<Bucket<V>> {
    final List<Bucket<V>> buckets;
    final Bucket<V> bucket = new Bucket(false);
    final IntervalTree<V, Bucket<V>> tree;

    public RefinedBuckets(List<Bucket<V>> buckets) {
        this.buckets = buckets.apply(bucket -> {
            if (bucket != null && bucket.getCount() > 0L) {
                return bucket.asUnmodifiable();
            }
            return null;
        }, Objects::nonNull);
        this.buckets.sort(Bucket::compareTo);
        IntervalTree.Builder<V, Bucket<V>> builder = new IntervalTree.Builder<V, Bucket<V>>();
        for (Bucket<V> bucket2 : this.buckets) {
            this.bucket.update(bucket2);
            builder.add(bucket2.getMinValue(), bucket2.getMaxValue(), bucket2);
        }
        this.tree = builder.build();
    }

    public Bucket<V> getBucket(int index) {
        return this.buckets.get(index);
    }

    public long getCount() {
        return this.bucket.getCount();
    }

    public V getMinValue() {
        return this.bucket.getMinValue();
    }

    public V getMaxValue() {
        return this.bucket.getMaxValue();
    }

    public Interval<V> getValueRange() {
        return new Interval<V>(this.getMinValue(), this.getMaxValue());
    }

    public long getMinPointer() {
        return this.bucket.getMinPointer();
    }

    public long getMaxPointer() {
        return this.bucket.getMaxPointer();
    }

    public long numOfRecords() {
        long count = 0L;
        for (Bucket<V> bucket : this.buckets) {
            count += bucket.getCount();
        }
        return count;
    }

    public LongInterval getRecordIndexRange() {
        return new LongInterval(this.getMinPointer(), this.getMaxPointer() + 1L);
    }

    public boolean contains(V value) {
        return this.tree.contains(value);
    }

    public boolean contains(V minValue, V maxValue) {
        return this.tree.contains(minValue, maxValue);
    }

    public boolean overlaps(V minValue, V maxValue) {
        return this.tree.overlaps(minValue, maxValue);
    }

    public List<Bucket<V>> getContains(V value) {
        return this.tree.getContains(value);
    }

    public List<Bucket<V>> getContains(V minValue, V maxValue) {
        return this.tree.getContains(minValue, maxValue);
    }

    public List<Bucket<V>> getOverlaps(V minValue, V maxValue) {
        return this.tree.getOverlaps(minValue, maxValue);
    }

    public int numOfBuckets() {
        return this.buckets.size();
    }

    public boolean isOrdered() {
        return this.bucket.isOrdered();
    }

    public boolean isCompact() {
        return this.bucket.isCompact();
    }

    @Override
    public Iterator<Bucket<V>> iterator() {
        return this.buckets.iterator();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int bucketIndex = 1;
        for (Bucket<V> bucket : this.buckets) {
            if (bucket.isCompact()) {
                builder.append("\nBucket " + bucketIndex + " (compact): " + bucket);
            } else {
                builder.append("\nBucket " + bucketIndex + ": " + bucket);
            }
            ++bucketIndex;
        }
        return builder.toString();
    }
}

