/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.indexer.intvalue;

import edu.sysu.pmglab.ccf.indexer.intvalue.IntBucket;
import edu.sysu.pmglab.ccf.indexer.intvalue.IntBucketFlusher;
import edu.sysu.pmglab.ccf.indexer.intvalue.RefinedIntBuckets;
import edu.sysu.pmglab.container.list.List;
import java.util.Iterator;

public class DynamicCrudeIntBuckets
implements Iterable<IntBucket> {
    final List<IntBucket> buckets;
    final IntBucketFlusher flusher;
    private IntBucket activeBucket = new IntBucket(false);

    public DynamicCrudeIntBuckets(IntBucketFlusher flusher) {
        this.flusher = flusher == null ? (bucket, value, pointer) -> bucket.getCount() >= 4096L : flusher;
        this.buckets = new List();
    }

    public RefinedIntBuckets refined() {
        return new RefinedIntBuckets(this.buckets);
    }

    public DynamicCrudeIntBuckets update(int value, long pointer) {
        if (this.activeBucket.getCount() == 0L) {
            this.activeBucket.update(value, pointer);
            this.buckets.add(this.activeBucket);
        } else {
            if (this.flusher.flush(this.activeBucket, value, pointer)) {
                this.activeBucket = new IntBucket();
                this.buckets.add(this.activeBucket);
            }
            this.activeBucket.update(value, pointer);
        }
        return this;
    }

    public DynamicCrudeIntBuckets update(DynamicCrudeIntBuckets crudeBucket) {
        for (int bucketIndex = 0; bucketIndex < crudeBucket.numOfBuckets(); ++bucketIndex) {
            IntBucket otherBucket = crudeBucket.getBucket(bucketIndex);
            if (otherBucket.getCount() <= 0L) continue;
            this.buckets.add(otherBucket);
        }
        return this;
    }

    public IntBucket getBucket(int index) {
        return this.buckets.get(index);
    }

    public int numOfBuckets() {
        return this.buckets.size();
    }

    @Override
    public Iterator<IntBucket> iterator() {
        return this.refined().iterator();
    }
}

