/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.indexer.intvalue;

import edu.sysu.pmglab.ccf.indexer.intvalue.IntBucket;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.objectpool.LinkedObjectPool;
import gnu.trove.function.TIntFunction;
import gnu.trove.function.TLongFunction;

public class FixedCrudeIntBuckets {
    final TLongFunction bucketBuilder;
    final LinkedObjectPool<IntBucket> buckets = new LinkedObjectPool<IntBucket>(() -> new IntBucket(true)).require(262144);

    public FixedCrudeIntBuckets(TIntFunction builder) {
        this.bucketBuilder = builder == null ? v -> 0L : l -> builder.execute((int)l);
    }

    public List<IntBucket> refined(int minRefinedBucketSize, int maxRefinedBucketSize) {
        List<IntBucket> refinedBuckets = new List<IntBucket>();
        IntBucket refinedBucket = new IntBucket(true);
        for (int bucketIndex = 0; bucketIndex < this.buckets.size(); ++bucketIndex) {
            IntBucket bucket;
            IntBucket intBucket = bucket = this.buckets.isInit(bucketIndex) ? this.buckets.fastGet(bucketIndex) : null;
            if (bucket == null || bucket.getCount() <= 0L) continue;
            if (refinedBucket.getCount() >= (long)minRefinedBucketSize && refinedBucket.isCompact()) {
                if (bucket.isCompact() && (refinedBucket.getMaxPointer() + 1L == bucket.getMinPointer() || refinedBucket.getMinPointer() == bucket.getMaxPointer() + 1L)) {
                    refinedBucket.update(bucket);
                } else {
                    refinedBuckets.add(refinedBucket);
                    refinedBucket = new IntBucket(true);
                    refinedBucket.update(bucket);
                }
            } else {
                refinedBucket.update(bucket);
            }
            if (refinedBucket.getCount() < (long)maxRefinedBucketSize) continue;
            refinedBuckets.add(refinedBucket);
            refinedBucket = new IntBucket(true);
        }
        if (refinedBucket.getCount() > 0L) {
            refinedBuckets.add(refinedBucket);
        }
        return refinedBuckets;
    }

    public FixedCrudeIntBuckets update(int value, long pointer) {
        long code = this.bucketBuilder.execute(value) - Integer.MIN_VALUE;
        int bucketIndex = (int)(code >>> 14);
        IntBucket bucket = this.buckets.get(bucketIndex);
        bucket.update(value, pointer);
        return this;
    }

    public FixedCrudeIntBuckets update(FixedCrudeIntBuckets crudeBucket) {
        for (int bucketIndex = 0; bucketIndex < this.buckets.size(); ++bucketIndex) {
            IntBucket otherBucket = crudeBucket.buckets.isInit(bucketIndex) ? crudeBucket.buckets.fastGet(bucketIndex) : null;
            if (otherBucket == null) continue;
            IntBucket bucket = this.buckets.get(bucketIndex);
            bucket.update(otherBucket);
        }
        return this;
    }

    public IntBucket getBucket(int index) {
        return this.buckets.get(index);
    }

    public int numOfBuckets() {
        return this.buckets.size();
    }

    public long getCount() {
        long count = 0L;
        for (IntBucket bucket : this.buckets) {
            count += bucket.getCount();
        }
        return count;
    }
}

