/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.indexer.intvalue;

import edu.sysu.pmglab.ccf.indexer.intvalue.IntBucket;
import edu.sysu.pmglab.container.interval.IntInterval;
import edu.sysu.pmglab.container.interval.LongInterval;
import edu.sysu.pmglab.container.intervaltree.inttree.IntIntervalTree;
import edu.sysu.pmglab.container.list.List;
import java.util.Iterator;
import java.util.Objects;

public class RefinedIntBuckets
implements Iterable<IntBucket> {
    final List<IntBucket> buckets;
    final IntBucket bucket = new IntBucket(false);
    final IntIntervalTree<IntBucket> tree;

    public RefinedIntBuckets(List<IntBucket> buckets) {
        this.buckets = buckets.apply(bucket -> {
            if (bucket != null && bucket.getCount() > 0L) {
                return bucket.asUnmodifiable();
            }
            return null;
        }, Objects::nonNull);
        this.buckets.sort(IntBucket::compareTo);
        IntIntervalTree.Builder<IntBucket> builder = new IntIntervalTree.Builder<IntBucket>();
        for (IntBucket bucket2 : this.buckets) {
            this.bucket.update(bucket2);
            builder.add(bucket2.getMinValue(), bucket2.getMaxValue(), bucket2);
        }
        this.tree = builder.build();
    }

    public IntBucket getBucket(int index) {
        return this.buckets.get(index);
    }

    public long getCount() {
        return this.bucket.getCount();
    }

    public int getMinValue() {
        return this.bucket.getMinValue();
    }

    public int getMaxValue() {
        return this.bucket.getMaxValue();
    }

    public IntInterval getValueRange() {
        return new IntInterval(this.getMinValue(), this.getMaxValue());
    }

    public long getMinPointer() {
        return this.bucket.getMinPointer();
    }

    public long getMaxPointer() {
        return this.bucket.getMaxPointer();
    }

    public LongInterval getRecordIndexRange() {
        return new LongInterval(this.getMinPointer(), this.getMaxPointer() + 1L);
    }

    public boolean contains(int value) {
        return this.tree.contains(value);
    }

    public boolean contains(int minValue, int maxValue) {
        return this.tree.contains(minValue, maxValue);
    }

    public boolean overlaps(int minValue, int maxValue) {
        return this.tree.overlaps(minValue, maxValue);
    }

    public List<IntBucket> getContains(int value) {
        return this.tree.getContains(value);
    }

    public List<IntBucket> getContains(int minValue, int maxValue) {
        return this.tree.getContains(minValue, maxValue);
    }

    public List<IntBucket> getOverlaps(int minValue, int maxValue) {
        return this.tree.getOverlaps(minValue, maxValue);
    }

    public int numOfBuckets() {
        return this.buckets.size();
    }

    public long numOfRecords() {
        long count = 0L;
        for (IntBucket bucket : this.buckets) {
            count += bucket.getCount();
        }
        return count;
    }

    public boolean isOrdered() {
        return this.bucket.isOrdered();
    }

    public boolean isCompact() {
        return this.bucket.isCompact();
    }

    @Override
    public Iterator<IntBucket> iterator() {
        return this.buckets.iterator();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int bucketIndex = 1;
        for (IntBucket bucket : this.buckets) {
            if (bucket.isCompact()) {
                builder.append("\nBucket " + bucketIndex + " (compact): " + bucket);
            } else {
                builder.append("\nBucket " + bucketIndex + ": " + bucket);
            }
            ++bucketIndex;
        }
        return builder.toString();
    }
}

