/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.indexer.longvalue;

import edu.sysu.pmglab.ccf.LiteTable;
import edu.sysu.pmglab.ccf.indexer.longvalue.LongBucket;
import edu.sysu.pmglab.ccf.indexer.longvalue.RefinedLongBuckets;
import edu.sysu.pmglab.ccf.record.IRecord;
import edu.sysu.pmglab.ccf.type.IFieldType;
import edu.sysu.pmglab.container.list.List;
import gnu.trove.map.hash.THashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CCFLongIndexer<K>
implements Iterable<K> {
    final Map<K, RefinedLongBuckets> buckets = new THashMap<K, RefinedLongBuckets>();
    final LiteTable table;

    public CCFLongIndexer(LiteTable table) {
        THashMap buckets = new THashMap();
        for (IRecord record : table.records()) {
            Object tag = record.get("TAG");
            long start = (Long)record.get("VALUE_START");
            long end = (Long)record.get("VALUE_END");
            long count = (Long)record.get("COUNT");
            long pointerStart = (Long)record.get("POINTER_START");
            long pointerEnd = (Long)record.get("POINTER_END");
            boolean ordered = (Boolean)record.get("ORDERED");
            if (count <= 0L) continue;
            if (!buckets.containsKey(tag)) {
                buckets.put(tag, new List());
            }
            ((List)buckets.get(tag)).add(new LongBucket(count, start, end, pointerStart, pointerEnd, ordered));
        }
        for (IRecord tag : buckets.keySet()) {
            this.buckets.put(tag, new RefinedLongBuckets((List)buckets.get(tag)));
        }
        this.table = table.asUnmodifiable();
    }

    public RefinedLongBuckets getTag(K tag) {
        return this.buckets.get(tag);
    }

    public Set<K> getTags() {
        return this.buckets.keySet();
    }

    public boolean containsTag(K tag) {
        return this.buckets.containsKey(tag);
    }

    public int numOfTags() {
        return this.buckets.size();
    }

    public long numOfRecords() {
        long count = 0L;
        for (K tag : this) {
            count += this.buckets.get(tag).getCount();
        }
        return count;
    }

    public IFieldType getTagType() {
        return this.table.getFieldType("TAG");
    }

    public IFieldType getValueType() {
        return this.table.getFieldType("VALUE_START");
    }

    public LiteTable toLiteTable() {
        return this.table;
    }

    public String getName() {
        return this.table.getName();
    }

    public String toString() {
        if (this.numOfTags() == 0) {
            return "<empty>";
        }
        List tags = List.wrap(this);
        tags.sort((o1, o2) -> Long.compare(this.buckets.get(o1).getBucket(0).getMinPointer(), this.buckets.get(o2).getBucket(0).getMinPointer()));
        StringBuilder builder = new StringBuilder();
        builder.append(this.table.getName() == null ? "Indexer" : "Indexer:" + this.table.getName());
        for (Object tag : tags) {
            RefinedLongBuckets buckets = this.getTag(tag);
            builder.append("\n    Tag " + tag + ": " + buckets.getCount() + " records in total");
            int bucketIndex = 1;
            for (LongBucket bucket : buckets) {
                builder.append("\n        Bucket " + bucketIndex + ": " + bucket);
                ++bucketIndex;
            }
        }
        return builder.toString();
    }

    public boolean isCompact() {
        for (RefinedLongBuckets buckets : this.buckets.values()) {
            if (buckets.isCompact()) continue;
            return false;
        }
        return true;
    }

    public boolean isOrdered() {
        for (RefinedLongBuckets buckets : this.buckets.values()) {
            if (buckets.isOrdered()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<K> iterator() {
        return this.buckets.keySet().iterator();
    }
}

