/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.indexer.longvalue;

import edu.sysu.pmglab.ccf.indexer.longvalue.LongBucket;
import edu.sysu.pmglab.ccf.indexer.longvalue.LongBucketFlusher;
import edu.sysu.pmglab.ccf.indexer.longvalue.RefinedLongBuckets;
import edu.sysu.pmglab.container.list.List;
import java.util.Iterator;

public class DynamicCrudeLongBuckets
implements Iterable<LongBucket> {
    final List<LongBucket> buckets;
    final LongBucketFlusher flusher;
    private LongBucket activeBucket = new LongBucket(false);

    public DynamicCrudeLongBuckets(LongBucketFlusher flusher) {
        this.flusher = flusher == null ? (bucket, value, pointer) -> bucket.getCount() >= 4096L : flusher;
        this.buckets = new List();
    }

    public RefinedLongBuckets refined() {
        return new RefinedLongBuckets(this.buckets);
    }

    public DynamicCrudeLongBuckets update(long value, long pointer) {
        if (this.activeBucket.getCount() == 0L) {
            this.activeBucket.update(value, pointer);
            this.buckets.add(this.activeBucket);
        } else {
            if (this.flusher.flush(this.activeBucket, value, pointer)) {
                this.activeBucket = new LongBucket();
                this.buckets.add(this.activeBucket);
            }
            this.activeBucket.update(value, pointer);
        }
        return this;
    }

    public DynamicCrudeLongBuckets update(DynamicCrudeLongBuckets crudeBucket) {
        for (int bucketIndex = 0; bucketIndex < crudeBucket.numOfBuckets(); ++bucketIndex) {
            LongBucket otherBucket = crudeBucket.getBucket(bucketIndex);
            if (otherBucket.getCount() <= 0L) continue;
            this.buckets.add(otherBucket);
        }
        return this;
    }

    public LongBucket getBucket(int index) {
        return this.buckets.get(index);
    }

    public int numOfBuckets() {
        return this.buckets.size();
    }

    @Override
    public Iterator<LongBucket> iterator() {
        return this.refined().iterator();
    }
}

