/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.indexer.longvalue;

import edu.sysu.pmglab.ccf.indexer.longvalue.LongBucket;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.objectpool.LinkedObjectPool;
import gnu.trove.function.TLongFunction;
import java.util.function.ToIntFunction;

public class FixedCrudeLongBuckets {
    final TLongFunction bucketBuilder;
    final LinkedObjectPool<LongBucket> buckets = new LinkedObjectPool<LongBucket>(() -> new LongBucket(true)).require(262144);

    public FixedCrudeLongBuckets(ToIntFunction<Long> builder) {
        this.bucketBuilder = builder == null ? v -> 0L : builder::applyAsInt;
    }

    public List<LongBucket> refined(int minRefinedBucketSize, int maxRefinedBucketSize) {
        List<LongBucket> refinedBuckets = new List<LongBucket>();
        LongBucket refinedBucket = new LongBucket(true);
        for (int bucketIndex = 0; bucketIndex < this.buckets.size(); ++bucketIndex) {
            LongBucket bucket;
            LongBucket longBucket = bucket = this.buckets.isInit(bucketIndex) ? this.buckets.fastGet(bucketIndex) : null;
            if (bucket == null || bucket.getCount() <= 0L) continue;
            if (refinedBucket.getCount() >= (long)minRefinedBucketSize && refinedBucket.isCompact()) {
                if (bucket.isCompact() && (refinedBucket.getMaxPointer() + 1L == bucket.getMinPointer() || refinedBucket.getMinPointer() == bucket.getMaxPointer() + 1L)) {
                    refinedBucket.update(bucket);
                } else {
                    refinedBuckets.add(refinedBucket);
                    refinedBucket = new LongBucket(true);
                    refinedBucket.update(bucket);
                }
            } else {
                refinedBucket.update(bucket);
            }
            if (refinedBucket.getCount() < (long)maxRefinedBucketSize) continue;
            refinedBuckets.add(refinedBucket);
            refinedBucket = new LongBucket(true);
        }
        if (refinedBucket.getCount() > 0L) {
            refinedBuckets.add(refinedBucket);
        }
        return refinedBuckets;
    }

    public FixedCrudeLongBuckets update(long value, long pointer) {
        long code = this.bucketBuilder.execute(value) - Integer.MIN_VALUE;
        int bucketIndex = (int)(code >>> 14);
        LongBucket bucket = this.buckets.get(bucketIndex);
        bucket.update(value, pointer);
        return this;
    }

    public FixedCrudeLongBuckets update(FixedCrudeLongBuckets crudeBucket) {
        for (int bucketIndex = 0; bucketIndex < this.buckets.size(); ++bucketIndex) {
            LongBucket otherBucket = crudeBucket.buckets.isInit(bucketIndex) ? crudeBucket.buckets.fastGet(bucketIndex) : null;
            if (otherBucket == null) continue;
            LongBucket bucket = this.buckets.get(bucketIndex);
            bucket.update(otherBucket);
        }
        return this;
    }

    public LongBucket getBucket(int index) {
        return this.buckets.get(index);
    }

    public int numOfBuckets() {
        return this.buckets.size();
    }

    public long getCount() {
        long count = 0L;
        for (LongBucket bucket : this.buckets) {
            count += bucket.getCount();
        }
        return count;
    }
}

