/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.indexer.longvalue;

import edu.sysu.pmglab.container.interval.LongInterval;
import edu.sysu.pmglab.container.rangelist.VarInt64RangeList;
import edu.sysu.pmglab.utils.ValueUtils;
import gnu.trove.iterator.TLongIterator;
import java.util.Comparator;

public class LongBucket
implements Comparable<LongBucket> {
    public static final Comparator<LongBucket> POINTER_COMPARATOR = Comparator.comparingLong(o -> o.minPointer);
    public static final Comparator<LongBucket> VALUE_COMPARATOR = LongBucket::compareTo;
    private final VarInt64RangeList pointers;
    long count = 0L;
    long minValue = Long.MAX_VALUE;
    long maxValue = Long.MIN_VALUE;
    long minPointer = -1L;
    long maxPointer = -1L;
    boolean ordered = true;

    public LongBucket() {
        this(true);
    }

    public LongBucket(boolean recordedPointer) {
        this.pointers = recordedPointer ? new VarInt64RangeList() : null;
    }

    public LongBucket(long count, long minValue, long maxValue, long minPointer, long maxPointer, boolean ordered) {
        this.count = count;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.minPointer = minPointer;
        this.maxPointer = maxPointer;
        this.ordered = ordered;
        this.pointers = this.isCompact() ? new VarInt64RangeList().addInterval(new LongInterval(this.minPointer, this.maxPointer)) : null;
    }

    public LongBucket update(long value, long pointer) {
        if (pointer < 0L) {
            throw new IllegalArgumentException("pointer < 0");
        }
        if (this.pointers != null) {
            this.pointers.add(pointer);
        }
        if (this.count == 0L) {
            this.minValue = value;
            this.maxValue = value;
            this.minPointer = pointer;
            this.maxPointer = pointer;
            this.ordered = true;
        } else if (this.ordered) {
            if (value >= this.maxValue) {
                if (pointer >= this.maxPointer) {
                    this.maxValue = value;
                    this.maxPointer = pointer;
                } else {
                    this.maxValue = value;
                    if (pointer < this.minPointer) {
                        this.minPointer = pointer;
                    }
                    this.ordered = false;
                }
            } else if (value <= this.minValue) {
                if (pointer <= this.minPointer) {
                    this.minValue = value;
                    this.minPointer = pointer;
                } else {
                    this.minValue = value;
                    if (pointer > this.maxPointer) {
                        this.maxPointer = pointer;
                    }
                    this.ordered = false;
                }
            } else {
                if (pointer > this.maxPointer) {
                    this.maxPointer = pointer;
                } else if (pointer < this.minPointer) {
                    this.minPointer = pointer;
                }
                this.ordered = false;
            }
        } else {
            if (value > this.maxValue) {
                this.maxValue = value;
            } else if (value < this.minValue) {
                this.minValue = value;
            }
            if (pointer > this.maxPointer) {
                this.maxPointer = pointer;
            } else if (pointer < this.minPointer) {
                this.minPointer = pointer;
            }
        }
        ++this.count;
        return this;
    }

    public LongBucket update(LongBucket bucket) {
        if (bucket == null || bucket.getCount() == 0L) {
            return this;
        }
        if (this.count == 0L) {
            this.count = bucket.count;
            this.maxValue = bucket.maxValue;
            this.minValue = bucket.minValue;
            this.maxPointer = bucket.maxPointer;
            this.minPointer = bucket.minPointer;
            this.ordered = bucket.ordered;
            if (this.pointers != null) {
                this.pointers.adds(bucket.pointers);
            }
            return this;
        }
        if (this.isOrdered() && bucket.isOrdered()) {
            if (this.maxPointer <= bucket.minPointer && this.maxValue <= bucket.minValue) {
                this.count += bucket.count;
                this.maxPointer = bucket.maxPointer;
                this.maxValue = bucket.maxValue;
                if (this.pointers != null) {
                    this.pointers.adds(bucket.pointers);
                }
                return this;
            }
            if (bucket.maxPointer <= this.minPointer && bucket.maxValue <= this.minValue) {
                this.count += bucket.count;
                this.minPointer = bucket.minPointer;
                this.minValue = bucket.minValue;
                if (this.pointers != null) {
                    VarInt64RangeList copy = new VarInt64RangeList().adds(bucket.pointers);
                    copy.adds(this.pointers);
                    this.pointers.clear();
                    this.pointers.adds(copy);
                }
                return this;
            }
        }
        this.count += bucket.count;
        this.maxValue = Math.max(this.maxValue, bucket.maxValue);
        this.minValue = Math.min(this.minValue, bucket.minValue);
        this.maxPointer = Math.max(this.maxPointer, bucket.maxPointer);
        this.minPointer = Math.min(this.minPointer, bucket.minPointer);
        this.ordered = false;
        if (this.pointers != null) {
            this.pointers.adds(bucket.pointers);
        }
        return this;
    }

    public long getCount() {
        return this.count;
    }

    public long getMinValue() {
        if (this.count == 0L) {
            throw new IllegalStateException("Empty bucket");
        }
        return this.minValue;
    }

    public long getMaxValue() {
        if (this.count == 0L) {
            throw new IllegalStateException("Empty bucket");
        }
        return this.maxValue;
    }

    public LongInterval getValueRange() {
        return new LongInterval(this.getMinValue(), this.getMaxValue());
    }

    public long getMinPointer() {
        if (this.count == 0L) {
            throw new IllegalStateException("Empty bucket");
        }
        return this.minPointer;
    }

    public long getMaxPointer() {
        if (this.count == 0L) {
            throw new IllegalStateException("Empty bucket");
        }
        return this.maxPointer;
    }

    public LongInterval getRecordIndexRange() {
        return this.getCount() > 0L ? new LongInterval(this.getMinPointer(), this.getMaxPointer() + 1L) : null;
    }

    public boolean contains(long value) {
        if (this.getCount() == 0L) {
            return false;
        }
        if (this.getCount() == 1L) {
            return this.getMinValue() == value;
        }
        if (this.getCount() == 2L) {
            return this.getMinValue() == value || this.getMaxValue() == value;
        }
        return this.getMinValue() <= value && this.getMaxValue() >= value;
    }

    public boolean contains(long minValue, long maxValue) {
        if (this.getCount() == 0L) {
            return false;
        }
        if (minValue > maxValue) {
            return false;
        }
        return this.getMinValue() <= minValue && this.getMaxValue() >= maxValue;
    }

    public boolean overlaps(long minValue, long maxValue) {
        if (this.getCount() == 0L) {
            return false;
        }
        if (minValue > maxValue) {
            return false;
        }
        return ValueUtils.intersect(minValue, maxValue, this.getMinValue(), this.getMaxValue());
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public boolean isCompact() {
        if (this.getCount() == 0L) {
            return true;
        }
        return this.getMaxPointer() - this.getMinPointer() == this.getCount() - 1L;
    }

    public LongBucket asUnmodifiable() {
        return new LongBucket(this.count, this.minValue, this.maxValue, this.minPointer, this.maxPointer, this.ordered){

            @Override
            public LongBucket update(long value, long pointer) {
                throw new UnsupportedOperationException();
            }

            @Override
            public LongBucket update(LongBucket bucket) {
                throw new UnsupportedOperationException();
            }

            @Override
            public LongBucket asUnmodifiable() {
                return this;
            }
        };
    }

    @Override
    public int compareTo(LongBucket o) {
        int status = Long.compare(this.getMinValue(), o.getMinValue());
        if (status == 0 && (status = Long.compare(this.getMaxValue(), o.getMaxValue())) == 0 && (status = Long.compare(this.getMinPointer(), o.getMaxPointer())) == 0 && (status = Long.compare(this.getMaxPointer(), o.getMaxPointer())) == 0) {
            status = Long.compare(this.getCount(), o.getCount());
        }
        return status;
    }

    public String toString() {
        return this.getCount() + " records in total, valueRange=[" + this.getMinValue() + ", " + this.getMaxValue() + "], pointerRange=[" + this.getMinPointer() + ", " + this.getMaxPointer() + "]";
    }

    public TLongIterator iterator() {
        if (this.pointers == null) {
            throw new IllegalStateException();
        }
        this.pointers.sort();
        return this.pointers.iterator();
    }

    public void destroy() {
        this.pointers.clear();
        this.count = 0L;
        this.minValue = Integer.MAX_VALUE;
        this.maxValue = Integer.MIN_VALUE;
        this.minPointer = -1L;
        this.maxPointer = -1L;
        this.ordered = true;
    }
}

