/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.indexer.longvalue;

import edu.sysu.pmglab.ccf.indexer.longvalue.LongBucket;
import edu.sysu.pmglab.container.interval.LongInterval;
import edu.sysu.pmglab.container.intervaltree.longtree.LongIntervalTree;
import edu.sysu.pmglab.container.list.List;
import java.util.Iterator;
import java.util.Objects;

public class RefinedLongBuckets
implements Iterable<LongBucket> {
    final List<LongBucket> buckets;
    final LongBucket bucket = new LongBucket(false);
    final LongIntervalTree<LongBucket> tree;

    public RefinedLongBuckets(List<LongBucket> buckets) {
        this.buckets = buckets.apply(bucket -> {
            if (bucket != null && bucket.getCount() > 0L) {
                return bucket.asUnmodifiable();
            }
            return null;
        }, Objects::nonNull);
        this.buckets.sort(LongBucket::compareTo);
        LongIntervalTree.Builder<LongBucket> builder = new LongIntervalTree.Builder<LongBucket>();
        for (LongBucket bucket2 : this.buckets) {
            this.bucket.update(bucket2);
            builder.add(bucket2.getMinValue(), bucket2.getMaxValue(), bucket2);
        }
        this.tree = builder.build();
    }

    public LongBucket getBucket(int index) {
        return this.buckets.get(index);
    }

    public long getCount() {
        return this.bucket.getCount();
    }

    public long getMinValue() {
        return this.bucket.getMinValue();
    }

    public long getMaxValue() {
        return this.bucket.getMaxValue();
    }

    public LongInterval getValueRange() {
        return new LongInterval(this.getMinValue(), this.getMaxValue());
    }

    public long getMinPointer() {
        return this.bucket.getMinPointer();
    }

    public long getMaxPointer() {
        return this.bucket.getMaxPointer();
    }

    public long numOfRecords() {
        long count = 0L;
        for (LongBucket bucket : this.buckets) {
            count += bucket.getCount();
        }
        return count;
    }

    public LongInterval getRecordIndexRange() {
        return new LongInterval(this.getMinPointer(), this.getMaxPointer() + 1L);
    }

    public boolean contains(long value) {
        return this.tree.contains(value);
    }

    public boolean contains(long minValue, long maxValue) {
        return this.tree.contains(minValue, maxValue);
    }

    public boolean overlaps(long minValue, long maxValue) {
        return this.tree.overlaps(minValue, maxValue);
    }

    public List<LongBucket> getContains(long value) {
        return this.tree.getContains(value);
    }

    public List<LongBucket> getContains(long minValue, long maxValue) {
        return this.tree.getContains(minValue, maxValue);
    }

    public List<LongBucket> getOverlaps(long minValue, long maxValue) {
        return this.tree.getOverlaps(minValue, maxValue);
    }

    public int numOfBuckets() {
        return this.buckets.size();
    }

    public boolean isOrdered() {
        return this.bucket.isOrdered();
    }

    public boolean isCompact() {
        return this.bucket.isCompact();
    }

    @Override
    public Iterator<LongBucket> iterator() {
        return this.buckets.iterator();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int bucketIndex = 1;
        for (LongBucket bucket : this.buckets) {
            if (bucket.isCompact()) {
                builder.append("\nBucket " + bucketIndex + " (compact): " + bucket);
            } else {
                builder.append("\nBucket " + bucketIndex + ": " + bucket);
            }
            ++bucketIndex;
        }
        return builder.toString();
    }
}

