/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.loader;

import edu.sysu.pmglab.container.interval.LongInterval;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.partreader.BoundReader;
import edu.sysu.pmglab.io.reader.ISeekableReaderStream;
import java.io.IOException;

public class CCFChunk {
    final LiveFile file;
    final Type type;
    final long start;
    final long length;

    CCFChunk(LiveFile file, Type type, long start, long length) {
        this.file = file;
        this.type = type;
        this.start = start;
        this.length = length;
    }

    public ISeekableReaderStream openReaderStream() throws IOException {
        return new BoundReader(this.file.openAsBinary(), new LongInterval(this.start, this.start + this.length));
    }

    public Type getType() {
        return this.type;
    }

    public LiveFile getFile() {
        return this.file;
    }

    public long getStart() {
        return this.start;
    }

    public long getLength() {
        return this.length;
    }

    public String toString() {
        return "CCFChunk{file=" + this.file + ", type=" + (Object)((Object)this.type) + ", start=" + this.start + ", length=" + this.length + '}';
    }

    public static enum Type {
        META(4),
        OPTION(4),
        FIELD_GROUP_META(4),
        FIELD_GROUP_DATA(8);

        final int length;

        private Type(int length) {
            this.length = length;
        }
    }
}

