/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.loader;

import edu.sysu.pmglab.ccf.CCFTable;
import edu.sysu.pmglab.ccf.exception.CCFComponentException;
import edu.sysu.pmglab.ccf.field.FieldGroupMeta;
import edu.sysu.pmglab.ccf.field.FieldGroupMetas;
import edu.sysu.pmglab.ccf.header.CCFHeader;
import edu.sysu.pmglab.ccf.header.CCFHeaders;
import edu.sysu.pmglab.ccf.header.CCFLiteHeader;
import edu.sysu.pmglab.ccf.loader.CCFChunk;
import edu.sysu.pmglab.ccf.loader.FieldGroupDataCodec;
import edu.sysu.pmglab.ccf.loader.FieldGroupMetaCodec;
import edu.sysu.pmglab.ccf.loader.Loader;
import edu.sysu.pmglab.ccf.loader.MetaCodec;
import edu.sysu.pmglab.ccf.loader.OptionCodec;
import edu.sysu.pmglab.ccf.meta.CCFMeta;
import edu.sysu.pmglab.ccf.meta.CCFOptions;
import edu.sysu.pmglab.ccf.toolkit.filter.IFilter;
import edu.sysu.pmglab.container.array.Array;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.reader.ReaderStream;
import gnu.trove.set.hash.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Set;

public class CCFLoader
implements Loader {
    final Set<CCFChunk.Type> types;
    final IFilter<FieldGroupMeta> filter;

    public CCFLoader() {
        this.types = null;
        this.filter = null;
    }

    public CCFLoader(Iterable<CCFChunk.Type> types) {
        if (types == null) {
            this.types = null;
        } else {
            this.types = new THashSet<CCFChunk.Type>();
            for (CCFChunk.Type type : types) {
                this.types.add(type);
            }
        }
        this.filter = null;
    }

    public CCFLoader(IFilter<FieldGroupMeta> filter) {
        this.types = null;
        this.filter = filter;
    }

    public CCFLoader(Iterable<CCFChunk.Type> types, IFilter<FieldGroupMeta> filter) {
        if (types == null) {
            this.types = null;
        } else {
            this.types = new THashSet<CCFChunk.Type>();
            for (CCFChunk.Type type : types) {
                this.types.add(type);
            }
        }
        this.filter = filter;
    }

    public CCFTable parse(String file) throws IOException {
        return new CCFTable(file, (Loader)this);
    }

    public CCFTable parse(File file) throws IOException {
        return new CCFTable(file, (Loader)this);
    }

    public CCFTable parse(LiveFile file) throws IOException {
        return new CCFTable(file, (Loader)this);
    }

    @Override
    public Object[] load(LiveFile file) throws IOException {
        CCFMeta METAS = new CCFMeta();
        CCFOptions OPTIONS = new CCFOptions();
        Array DATA_GROUPS = new Array(1);
        try (ReaderStream reader = new ReaderStream(file.openAsBinary());){
            List<CCFChunk> chunks = Loader.scan(file, this.types);
            chunks.filterInplace(chunk -> {
                try {
                    if (chunk.getType() == CCFChunk.Type.META) {
                        METAS.adds(MetaCodec.decode(chunk, reader));
                        return false;
                    }
                    if (chunk.getType() == CCFChunk.Type.OPTION) {
                        OPTIONS.adds(OptionCodec.decode(chunk, reader));
                        return false;
                    }
                    if (chunk.getType() == CCFChunk.Type.FIELD_GROUP_META) {
                        FieldGroupMetaCodec.Chunk fieldGroup = FieldGroupMetaCodec.decode(chunk, reader);
                        DATA_GROUPS.ensureIndex(fieldGroup.getGroupId());
                        if (DATA_GROUPS.get(fieldGroup.getGroupId()) != null) {
                            throw new CCFComponentException("Duplicated field group ID: " + fieldGroup.getGroupId());
                        }
                        DATA_GROUPS.set(fieldGroup.getGroupId(), new DataGroup(fieldGroup.getAllFields(), this.filter == null || this.filter.filter(fieldGroup.getAllFields())));
                        return false;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return true;
            });
            chunks.filterInplace(chunk -> {
                try {
                    if (chunk.getType() == CCFChunk.Type.FIELD_GROUP_DATA) {
                        FieldGroupDataCodec.decodeTo(chunk, reader, DATA_GROUPS);
                        return false;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return true;
            });
        }
        LinkedHashMap<String, CCFHeaders> headers = new LinkedHashMap<String, CCFHeaders>();
        FieldGroupMetas fields = new FieldGroupMetas();
        for (int i = 0; i < DATA_GROUPS.length(); ++i) {
            DataGroup group = (DataGroup)DATA_GROUPS.get(i);
            if (group == null || !group.isLoad()) continue;
            if (fields.containsFieldGroup(group.getFieldGroupName())) {
                throw new CCFComponentException("Duplicated field group: " + group.getFieldGroupName());
            }
            fields.addFields((Iterable)group.getFieldGroup());
            long records = 0L;
            int lastChunkIndex = Integer.MIN_VALUE;
            List<CCFHeader> blocks = new List<CCFHeader>();
            List<FieldGroupDataCodec.DataChunk> chunks = group.getChunks();
            chunks.sort();
            while (chunks.size() > 0) {
                FieldGroupDataCodec.DataChunk chunk2 = chunks.popFirst();
                if (lastChunkIndex >= chunk2.getChunkId()) {
                    throw new CCFComponentException("Duplicated field group block " + chunk2.getChunkId() + " in field group " + group.getFieldGroupName());
                }
                lastChunkIndex = chunk2.getChunkId();
                long pointer = chunk2.getPointer();
                for (CCFLiteHeader block : chunk2.getBlocks()) {
                    blocks.add(new CCFHeader(pointer, block.length(), block.numOfRecords(), records, records + (long)block.numOfRecords() - 1L));
                    pointer += (long)block.length();
                    records += (long)block.numOfRecords();
                }
                headers.put(group.getFieldGroupName(), new CCFHeaders(group.getFieldGroup(), blocks));
            }
        }
        long records = -1L;
        for (String group : headers.keySet()) {
            CCFHeaders blocks = (CCFHeaders)headers.get(group);
            if (records == -1L) {
                records = blocks.numOfRecords();
                continue;
            }
            if (records == blocks.numOfRecords()) continue;
            throw new CCFComponentException("Field group '" + group + "' contains a record count inconsistent with the expected quantity of " + records);
        }
        if (records == -1L) {
            return new Object[]{METAS.asUnmodifiable(), OPTIONS.asUnmodifiable(), fields.asUnmodifiable(), Collections.unmodifiableMap(headers), 0L};
        }
        return new Object[]{METAS.asUnmodifiable(), OPTIONS.asUnmodifiable(), fields.asUnmodifiable(), Collections.unmodifiableMap(headers), records};
    }

    static class DataGroup {
        final FieldGroupMeta group;
        final List<FieldGroupDataCodec.DataChunk> chunks;

        public DataGroup(FieldGroupMeta group, boolean load) {
            this.group = group;
            this.chunks = load ? new List() : null;
        }

        public void addChunk(FieldGroupDataCodec.DataChunk chunk) {
            if (this.chunks != null) {
                this.chunks.add(chunk);
            }
        }

        public boolean isLoad() {
            return this.chunks != null;
        }

        public String getFieldGroupName() {
            return this.group.groupName();
        }

        public FieldGroupMeta getFieldGroup() {
            return this.group;
        }

        public List<FieldGroupDataCodec.DataChunk> getChunks() {
            if (this.chunks == null) {
                return List.EMPTY();
            }
            this.chunks.sort();
            return this.chunks;
        }
    }
}

