/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.loader;

import edu.sysu.pmglab.ccf.exception.CCFComponentException;
import edu.sysu.pmglab.ccf.header.CCFLiteHeader;
import edu.sysu.pmglab.ccf.loader.CCFChunk;
import edu.sysu.pmglab.ccf.loader.CCFLoader;
import edu.sysu.pmglab.container.array.Array;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.io.reader.ISeekableReaderStream;
import java.io.IOException;

public class FieldGroupDataCodec {
    private FieldGroupDataCodec() {
        throw new UnsupportedOperationException("Cannot instantiate utility class");
    }

    public static CCFChunk.Type getType() {
        return CCFChunk.Type.FIELD_GROUP_DATA;
    }

    public static DataChunk decode(CCFChunk chunk, ISeekableReaderStream reader) throws IOException {
        reader.seek(chunk.start);
        int groupIndex = reader.readVarInt32();
        int chunkIndex = reader.readVarInt32();
        int numOfBlocks = reader.readVarInt32();
        List<CCFLiteHeader> blocks = new List<CCFLiteHeader>(numOfBlocks);
        for (int i = 0; i < numOfBlocks; ++i) {
            int numOfRecords = reader.readVarInt32();
            int lengthOfData = reader.readVarInt32();
            blocks.add(new CCFLiteHeader(numOfRecords, lengthOfData));
        }
        return new DataChunk(groupIndex, chunkIndex, reader.tell(), blocks);
    }

    public static void decodeTo(CCFChunk chunk, ISeekableReaderStream reader, Array<CCFLoader.DataGroup> groups2) throws IOException {
        reader.seek(chunk.start);
        int groupIndex = reader.readVarInt32();
        if (groupIndex < 0) {
            throw new CCFComponentException("Illegal field group ID: " + groupIndex + " (< 0)");
        }
        if (groupIndex >= groups2.length()) {
            throw new CCFComponentException("Undefined field group meta for field group ID '" + groupIndex + "'");
        }
        CCFLoader.DataGroup group = groups2.get(groupIndex);
        if (group == null) {
            throw new CCFComponentException("Undefined field group meta for field group ID '" + groupIndex + "'");
        }
        if (group.isLoad()) {
            int chunkIndex = reader.readVarInt32();
            if (chunkIndex < 0) {
                throw new CCFComponentException("Illegal field group data chunk ID: " + chunkIndex + " (< 0)");
            }
            int numOfBlocks = reader.readVarInt32();
            List<CCFLiteHeader> blocks = new List<CCFLiteHeader>(numOfBlocks);
            for (int i = 0; i < numOfBlocks; ++i) {
                int numOfRecords = reader.readVarInt32();
                int lengthOfData = reader.readVarInt32();
                blocks.add(new CCFLiteHeader(numOfRecords, lengthOfData));
            }
            group.addChunk(new DataChunk(groupIndex, chunkIndex, reader.tell(), blocks));
        }
    }

    public static class DataChunk
    implements Comparable<DataChunk> {
        final int groupId;
        final int chunkId;
        final long pointer;
        final List<CCFLiteHeader> blocks;

        public DataChunk(int groupId, int chunkId, long pointer, List<CCFLiteHeader> blocks) {
            this.groupId = groupId;
            this.chunkId = chunkId;
            this.pointer = pointer;
            this.blocks = blocks;
        }

        public int getGroupId() {
            return this.groupId;
        }

        public int getChunkId() {
            return this.chunkId;
        }

        public long getPointer() {
            return this.pointer;
        }

        public List<CCFLiteHeader> getBlocks() {
            return this.blocks;
        }

        @Override
        public int compareTo(DataChunk o) {
            return Integer.compare(this.chunkId, o.chunkId);
        }
    }
}

