/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.loader;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.exception.CCFComponentException;
import edu.sysu.pmglab.ccf.field.FieldGroupMeta;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.loader.CCFChunk;
import edu.sysu.pmglab.ccf.type.IFieldType;
import edu.sysu.pmglab.io.reader.ISeekableReaderStream;
import edu.sysu.pmglab.io.writer.IWriterStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class FieldGroupMetaCodec {
    private FieldGroupMetaCodec() {
        throw new UnsupportedOperationException("Cannot instantiate utility class");
    }

    public static CCFChunk.Type getType() {
        return CCFChunk.Type.FIELD_GROUP_META;
    }

    public static Chunk decode(CCFChunk chunk, ISeekableReaderStream reader) throws IOException {
        if (chunk.length >= 0x7FFFFFFDL) {
            throw new OutOfMemoryError("Out Of Memory: " + chunk.length);
        }
        reader.seek(chunk.start);
        return FieldGroupMetaCodec.decode(reader.readBytes((int)chunk.length));
    }

    public static Chunk decode(Bytes codec) throws IOException {
        ByteStream reader = codec.toByteStream();
        int index = reader.getVarInt32();
        if (index < 0) {
            throw new CCFComponentException("Illegal field group ID: " + index + " (< 0)");
        }
        FieldGroupMeta group = new FieldGroupMeta(reader.getString(StandardCharsets.UTF_8));
        while (reader.rRemaining() > 0) {
            group.addField(group.groupName(), reader.getString(StandardCharsets.UTF_8), IFieldType.get(reader.getString(StandardCharsets.UTF_8)));
        }
        reader.close();
        return new Chunk(index, group.asUnmodifiable());
    }

    private static Bytes encode(int index, FieldGroupMeta meta) {
        if (index < 0) {
            throw new CCFComponentException("Illegal field group ID: " + index + " (< 0)");
        }
        ByteStream container = ByteStream.getThreadInstance();
        container.putVarInt32(index);
        container.putString(meta.groupName(), StandardCharsets.UTF_8, true);
        for (FieldMeta field : meta) {
            container.putString(field.simpleName(), StandardCharsets.UTF_8, true);
            container.putString(field.type().getName(), StandardCharsets.UTF_8, true);
        }
        return container.toBytes(true);
    }

    public static int saveTo(IFieldCollection groups2, IWriterStream output) throws IOException {
        groups2.asUnmodifiable();
        int groupID = 0;
        int count = 0;
        for (FieldGroupMeta group : groups2.getAllFieldGroups()) {
            Bytes codec = FieldGroupMetaCodec.encode(groupID++, group);
            output.write(FieldGroupMetaCodec.getType().ordinal());
            output.writeLong(codec.length(), FieldGroupMetaCodec.getType().length);
            output.write(codec);
            count += 1 + FieldGroupMetaCodec.getType().length + codec.length();
        }
        return count;
    }

    public static int saveTo(int index, FieldGroupMeta group, IWriterStream output) throws IOException {
        group.asUnmodifiable();
        Bytes codec = FieldGroupMetaCodec.encode(index, group);
        output.write(FieldGroupMetaCodec.getType().ordinal());
        output.writeLong(codec.length(), FieldGroupMetaCodec.getType().length);
        output.write(codec);
        return 1 + FieldGroupMetaCodec.getType().length + codec.length();
    }

    static class Chunk
    implements Comparable<Chunk> {
        final int groupId;
        final FieldGroupMeta fields;

        public Chunk(int groupId, FieldGroupMeta fields) {
            this.groupId = groupId;
            this.fields = fields;
        }

        public int getGroupId() {
            return this.groupId;
        }

        public FieldGroupMeta getAllFields() {
            return this.fields;
        }

        public String groupName() {
            return this.fields.groupName();
        }

        @Override
        public int compareTo(Chunk o) {
            return Integer.compare(this.groupId, o.groupId);
        }
    }
}

