/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.loader;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.ccf.exception.CCFComponentException;
import edu.sysu.pmglab.ccf.loader.CCFChunk;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.io.file.LiveFile;
import edu.sysu.pmglab.io.reader.ISeekableReaderStream;
import java.io.IOException;
import java.util.Set;

public interface Loader {
    public static List<CCFChunk> scan(LiveFile file, Set<CCFChunk.Type> types) throws IOException {
        try {
            List<CCFChunk> chunks = new List<CCFChunk>();
            ByteStream cache = ByteStream.getThreadInstance();
            try (ISeekableReaderStream reader = file.openAsBinary();){
                long length;
                CCFChunk.Type type;
                for (long start = 0L; start < file.length(); start += (long)(1 + type.length) + length) {
                    cache.clear();
                    reader.seek(start);
                    type = CCFChunk.Type.values()[reader.read()];
                    if (reader.read(cache, type.length) != type.length) {
                        throw new CCFComponentException("Exception information at file pointer: " + (start + 1L) + ", caught type " + (Object)((Object)type) + ", but insufficient length to obtain the total length of this data segment (required: " + type.length + " bytes)");
                    }
                    length = cache.getLong(type.length);
                    if (types != null && !types.contains((Object)type)) continue;
                    chunks.add(new CCFChunk(file, type, start + 1L + (long)type.length, length));
                }
            }
            return chunks.asUnmodifiable();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new CCFComponentException("Invalid file format: Expected file '" + file + "' in Columnar Chunked Format (CCF) but received a different format");
        }
    }

    public Object[] load(LiveFile var1) throws IOException;
}

