/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.loader;

import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.loader.CCFChunk;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.io.reader.ISeekableReaderStream;
import edu.sysu.pmglab.io.writer.IWriterStream;
import java.io.IOException;

public class MetaCodec {
    private MetaCodec() {
        throw new UnsupportedOperationException("Cannot instantiate utility class");
    }

    public static CCFChunk.Type getType() {
        return CCFChunk.Type.META;
    }

    public static ICCFMeta decode(CCFChunk chunk, ISeekableReaderStream reader) throws IOException {
        if (chunk.length >= 0x7FFFFFFDL) {
            throw new OutOfMemoryError("Out Of Memory: " + chunk.length);
        }
        reader.seek(chunk.start);
        return MetaCodec.decode(reader.readBytes((int)chunk.length));
    }

    public static ICCFMeta decode(Bytes bytes) throws IOException {
        return ICCFMeta.decode(bytes);
    }

    public static Bytes encode(ICCFMeta metas) throws IOException {
        return metas.encode();
    }

    public static int saveTo(ICCFMeta metas, IWriterStream output) throws IOException {
        Bytes bytes;
        if (metas != null && metas.size() > 0 && (bytes = metas.encode()).length() > 0) {
            output.write(MetaCodec.getType().ordinal());
            output.writeLong(bytes.length(), MetaCodec.getType().length);
            output.write(bytes);
            return 1 + MetaCodec.getType().length + bytes.length();
        }
        return 0;
    }
}

