/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.loader;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.compressor.ICompressor;
import edu.sysu.pmglab.ccf.loader.CCFChunk;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.meta.ICCFOptions;
import edu.sysu.pmglab.io.reader.ISeekableReaderStream;
import edu.sysu.pmglab.io.writer.IWriterStream;
import java.io.IOException;

public class OptionCodec {
    private OptionCodec() {
        throw new UnsupportedOperationException("Cannot instantiate utility class");
    }

    public static CCFChunk.Type getType() {
        return CCFChunk.Type.OPTION;
    }

    public static ICCFOptions decode(CCFChunk chunk, ISeekableReaderStream reader) throws IOException {
        if (chunk.length >= 0x7FFFFFFDL) {
            throw new OutOfMemoryError("Out Of Memory: " + chunk.length);
        }
        reader.seek(chunk.start);
        return OptionCodec.decode(reader.readBytes((int)chunk.length));
    }

    public static ICCFOptions decode(Bytes bytes) throws IOException {
        return ICCFOptions.decode(bytes);
    }

    public static Bytes encode(ICCFOptions options) throws IOException {
        return options.encode();
    }

    public static int saveTo(ICCFOptions options, IWriterStream output) throws IOException {
        Bytes bytes;
        if (options != null && options.size() > 0 && (bytes = options.encode()).length() > 0) {
            output.write(OptionCodec.getType().ordinal());
            output.writeLong(bytes.length(), OptionCodec.getType().length);
            output.write(bytes);
            return 1 + OptionCodec.getType().length + bytes.length();
        }
        return 0;
    }

    public static int saveTo(CCFMetaItem option, IWriterStream output) throws IOException {
        if (option != null) {
            ByteStream container = new ByteStream();
            container.putBytes(option.encode(), true);
            Bytes bytes = ICompressor.compress(RuntimeProperty.DEFAULT_COMPRESSOR, container.toBytes());
            if (bytes.length() > 0) {
                output.write(OptionCodec.getType().ordinal());
                output.writeLong(bytes.length(), OptionCodec.getType().length);
                output.write(bytes);
                return 1 + OptionCodec.getType().length + bytes.length();
            }
        }
        return 0;
    }
}

