/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.meta;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.meta.ICCFMeta;
import edu.sysu.pmglab.container.iterator.NestedIterator;
import edu.sysu.pmglab.container.list.List;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class CCFMeta
implements ICCFMeta {
    final Map<String, List<CCFMetaItem>> data = new LinkedHashMap<String, List<CCFMetaItem>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CCFMeta add(CCFMetaItem item) {
        if (item != null) {
            CCFMeta cCFMeta = this;
            synchronized (cCFMeta) {
                if (!this.data.containsKey(item.getKey())) {
                    this.data.put(item.getKey(), new List(1));
                }
                List<CCFMetaItem> meta = this.data.get(item.getKey());
                if (item.getKey().startsWith("$") && meta.size() != 0) {
                    meta.clear();
                }
                meta.add(item);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CCFMeta dropDuplicates() {
        CCFMeta cCFMeta = this;
        synchronized (cCFMeta) {
            for (String key : this.data.keySet()) {
                this.data.get(key).dropDuplicates();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CCFMeta clear() {
        CCFMeta cCFMeta = this;
        synchronized (cCFMeta) {
            this.data.clear();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CCFMeta remove(String ... keys2) {
        if (keys2 != null) {
            CCFMeta cCFMeta = this;
            synchronized (cCFMeta) {
                for (String key : keys2) {
                    if (!this.data.containsKey(key)) continue;
                    this.data.get(key).close();
                    this.data.remove(key);
                }
            }
        }
        return this;
    }

    @Override
    public boolean contains(String key) {
        return this.data.containsKey(key);
    }

    @Override
    public int numOfMeta(String key) {
        List<CCFMetaItem> meta = this.data.get(key);
        return meta == null ? 0 : meta.size();
    }

    @Override
    public List<CCFMetaItem> get(String key) {
        List<CCFMetaItem> meta = this.data.get(key);
        if (meta == null || meta.size() == 0) {
            return List.EMPTY();
        }
        return meta.asUnmodifiable();
    }

    @Override
    public <T> List<T> getValues(String key) {
        List<CCFMetaItem> meta = this.data.get(key);
        if (meta == null || meta.size() == 0) {
            return List.EMPTY();
        }
        return meta.apply(m -> m.getValue()).asUnmodifiable();
    }

    @Override
    public Set<String> keys() {
        return this.data.keySet();
    }

    @Override
    public int size() {
        int count = 0;
        for (String key : this.data.keySet()) {
            count += this.data.get(key).size();
        }
        return count;
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    @Override
    public Iterator<CCFMetaItem> iterator() {
        return new NestedIterator<CCFMetaItem>(this.data.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        ByteStream container = new ByteStream();
        for (CCFMetaItem meta : this) {
            if (container.length() > 0) {
                container.write(10);
            }
            container.writeChar(meta.toString());
        }
        try {
            String string = container.toBytes().toString();
            return string;
        }
        finally {
            container.close();
        }
    }
}

