/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.meta;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.exception.CCFCodingException;
import edu.sysu.pmglab.ccf.type.FieldType;
import edu.sysu.pmglab.ccf.type.IFieldType;
import edu.sysu.pmglab.container.array.StringArray;
import edu.sysu.pmglab.container.indexable.IndexableSet;
import edu.sysu.pmglab.container.list.List;
import edu.sysu.pmglab.utils.Assert;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class CCFMetaItem {
    private static final ThreadLocal<ByteStream> temps = ThreadLocal.withInitial(ByteStream::new);
    private final String key;
    private final IFieldType type;
    private final Object value;
    private final int hashcode;

    public CCFMetaItem(String key, IFieldType type, Object value) {
        Assert.that(key != null && key.length() > 0);
        this.key = key;
        this.type = type == null ? FieldType.NULL : type;
        this.value = value;
        this.hashcode = Objects.hash(this.key, this.type, this.value);
    }

    public static CCFMetaItem of(String key) {
        return new CCFMetaItem(key, FieldType.NULL, null);
    }

    public static CCFMetaItem of(String key, String value) {
        return new CCFMetaItem(key, FieldType.string, value);
    }

    public static CCFMetaItem of(String key, String[] value) {
        return new CCFMetaItem(key, FieldType.stringArray, new StringArray(value));
    }

    public static CCFMetaItem of(String key, List<String> value) {
        return new CCFMetaItem(key, FieldType.stringList, value);
    }

    public static CCFMetaItem of(String key, Set<String> value) {
        if (value instanceof IndexableSet) {
            return new CCFMetaItem(key, FieldType.stringIndexableSet, value);
        }
        return new CCFMetaItem(key, FieldType.stringSet, value);
    }

    public static CCFMetaItem of(String key, Map<String, String> value) {
        return new CCFMetaItem(key, FieldType.stringSet, value);
    }

    public static CCFMetaItem decode(Bytes cache) {
        ByteStream reader = cache.toByteStream();
        String key = reader.getString();
        IFieldType type = IFieldType.get(reader.getString());
        int length = reader.getVarInt32();
        if (length == -1) {
            if (reader.rRemaining() > 0) {
                throw new CCFCodingException("Invalid input length");
            }
            reader.close();
            return new CCFMetaItem(key, type, null);
        }
        CCFMetaItem meta = new CCFMetaItem(key, type, type.decode(reader.getBytes(length)));
        if (reader.rRemaining() > 0) {
            throw new CCFCodingException("Invalid input length");
        }
        reader.close();
        return meta;
    }

    public Bytes encode() {
        ByteStream container = temps.get().clear();
        container.putString(this.key, true);
        container.putString(this.type.getName(), true);
        if (this.type == FieldType.NULL || this.value == null) {
            container.putVarInt32(-1);
        } else {
            container.putBytes(this.type.encode(this.value), true);
        }
        return container.toBytes(true);
    }

    public String getKey() {
        return this.key;
    }

    public <T> T getValue() {
        return (T)this.value;
    }

    public IFieldType getType() {
        return this.type;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CCFMetaItem that = (CCFMetaItem)o;
        if (this.hashcode != ((CCFMetaItem)o).hashcode) {
            return false;
        }
        return this.key.equals(that.key) && this.type == that.type && this.encode().valueEquals(that.encode());
    }

    public String toString() {
        if (this.type == FieldType.NULL) {
            return this.key;
        }
        return this.key + "=" + this.value;
    }
}

