/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.meta;

import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.ccf.exception.CCFComponentException;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.meta.ICCFOptions;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class CCFOptions
implements ICCFOptions {
    final Map<String, CCFMetaItem> data = new LinkedHashMap<String, CCFMetaItem>(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CCFOptions add(CCFMetaItem item) {
        if (item != null) {
            CCFOptions cCFOptions = this;
            synchronized (cCFOptions) {
                if (this.data.containsKey(item.getKey())) {
                    throw new CCFComponentException("Duplicated option: " + item.getKey());
                }
                this.data.put(item.getKey(), item);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CCFOptions clear() {
        CCFOptions cCFOptions = this;
        synchronized (cCFOptions) {
            this.data.clear();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CCFOptions remove(String ... keys2) {
        if (keys2 != null) {
            CCFOptions cCFOptions = this;
            synchronized (cCFOptions) {
                for (String key : keys2) {
                    this.data.remove(key);
                }
            }
        }
        return this;
    }

    @Override
    public boolean contains(String key) {
        return this.data.containsKey(key);
    }

    @Override
    public Set<String> keys() {
        return this.data.keySet();
    }

    @Override
    public <T> T get(String key) {
        CCFMetaItem item = this.data.get(key);
        if (item == null) {
            return null;
        }
        return item.getValue();
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    @Override
    public Iterator<CCFMetaItem> iterator() {
        return this.data.values().iterator();
    }

    public <T> T get(String key, T defaults) {
        if (this.data.containsKey(key)) {
            return this.data.get(key).getValue();
        }
        return defaults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        ByteStream container = new ByteStream();
        for (CCFMetaItem meta : this) {
            if (container.length() > 0) {
                container.write(10);
            }
            container.writeChar(meta.toString());
        }
        try {
            String string = container.toBytes().toString();
            return string;
        }
        finally {
            container.close();
        }
    }
}

