/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.meta;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.compressor.ICompressor;
import edu.sysu.pmglab.ccf.compressor.IDecompressor;
import edu.sysu.pmglab.ccf.meta.CCFMeta;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.toolkit.filter.IFilter;
import edu.sysu.pmglab.ccf.type.IFieldType;
import edu.sysu.pmglab.container.iterator.EmptyIterator;
import edu.sysu.pmglab.container.iterator.FilterIterator;
import edu.sysu.pmglab.container.list.List;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public interface ICCFMeta
extends Iterable<CCFMetaItem> {
    public static final ICCFMeta EMPTY = new ICCFMeta(){

        @Override
        public ICCFMeta add(CCFMetaItem item) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ICCFMeta adds(Iterable<CCFMetaItem> meta) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ICCFMeta dropDuplicates() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ICCFMeta clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ICCFMeta remove(String ... keys2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(String key) {
            return false;
        }

        @Override
        public int numOfMeta(String key) {
            return 0;
        }

        @Override
        public List<CCFMetaItem> get(String key) {
            return List.EMPTY();
        }

        @Override
        public <T> List<T> getValues(String key) {
            return List.EMPTY();
        }

        @Override
        public Iterable<CCFMetaItem> filter(IFilter<CCFMetaItem> filter) {
            return EmptyIterator::INSTANCE;
        }

        @Override
        public Set<String> keys() {
            return Collections.EMPTY_SET;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isModifiable() {
            return false;
        }

        @Override
        public Iterator<CCFMetaItem> iterator() {
            return EmptyIterator.INSTANCE();
        }

        @Override
        public ICCFMeta asUnmodifiable() {
            return this;
        }

        public String toString() {
            return "";
        }
    };

    public static ICCFMeta decode(Bytes codec) {
        if (codec == null || codec.length() == 0) {
            return EMPTY;
        }
        ByteStream reader = IDecompressor.decompress(RuntimeProperty.DEFAULT_DECOMPRESSOR, codec).toByteStream();
        CCFMeta container = new CCFMeta();
        while (reader.rRemaining() > 0) {
            Bytes meta = reader.getBytes();
            if (meta == null) continue;
            container.add(CCFMetaItem.decode(meta));
        }
        reader.close();
        return container.size() == 0 ? CCFMeta.EMPTY : container.asUnmodifiable();
    }

    public ICCFMeta add(CCFMetaItem var1);

    default public ICCFMeta add(String key) {
        return this.add(CCFMetaItem.of(key));
    }

    default public ICCFMeta add(String key, String value) {
        return this.add(CCFMetaItem.of(key, value));
    }

    default public ICCFMeta add(String key, String[] value) {
        return this.add(CCFMetaItem.of(key, value));
    }

    default public ICCFMeta add(String key, Set<String> value) {
        return this.add(CCFMetaItem.of(key, value));
    }

    default public ICCFMeta add(String key, List<String> value) {
        return this.add(CCFMetaItem.of(key, value));
    }

    default public ICCFMeta add(String key, IFieldType type, Object value) {
        return this.add(new CCFMetaItem(key, type, value));
    }

    default public ICCFMeta add(String key, Map<String, String> value) {
        return this.add(CCFMetaItem.of(key, value));
    }

    default public ICCFMeta adds(Iterable<CCFMetaItem> meta) {
        if (meta != null) {
            for (CCFMetaItem item : meta) {
                this.add(item);
            }
        }
        return this;
    }

    public ICCFMeta dropDuplicates();

    public ICCFMeta clear();

    public ICCFMeta remove(String ... var1);

    public boolean contains(String var1);

    public int numOfMeta(String var1);

    public List<CCFMetaItem> get(String var1);

    public <T> List<T> getValues(String var1);

    default public Iterable<CCFMetaItem> filter(IFilter<CCFMetaItem> filter) {
        if (filter == null) {
            return this;
        }
        return () -> new FilterIterator<CCFMetaItem>(this, filter);
    }

    public Set<String> keys();

    public int size();

    public boolean isModifiable();

    @Override
    public Iterator<CCFMetaItem> iterator();

    default public ICCFMeta asUnmodifiable() {
        return new ICCFMeta(){

            @Override
            public ICCFMeta add(CCFMetaItem item) {
                throw new UnsupportedOperationException();
            }

            @Override
            public ICCFMeta dropDuplicates() {
                throw new UnsupportedOperationException();
            }

            @Override
            public ICCFMeta clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            public ICCFMeta remove(String ... keys2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean contains(String key) {
                return ICCFMeta.this.contains(key);
            }

            @Override
            public int numOfMeta(String key) {
                return ICCFMeta.this.numOfMeta(key);
            }

            @Override
            public List<CCFMetaItem> get(String key) {
                return ICCFMeta.this.get(key);
            }

            @Override
            public <T> List<T> getValues(String key) {
                return ICCFMeta.this.getValues(key);
            }

            @Override
            public Set<String> keys() {
                return ICCFMeta.this.keys();
            }

            @Override
            public int size() {
                return ICCFMeta.this.size();
            }

            @Override
            public boolean isModifiable() {
                return false;
            }

            @Override
            public Iterator<CCFMetaItem> iterator() {
                return ICCFMeta.this.iterator();
            }

            @Override
            public ICCFMeta asUnmodifiable() {
                return this;
            }

            public String toString() {
                return ICCFMeta.this.toString();
            }
        };
    }

    default public Bytes encode() {
        if (this.size() == 0) {
            return Bytes.EMPTY;
        }
        ByteStream container = new ByteStream();
        for (CCFMetaItem meta : this) {
            container.putBytes(meta.encode(), true);
        }
        return ICompressor.compress(RuntimeProperty.DEFAULT_COMPRESSOR, container.toBytes());
    }
}

