/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.meta;

import edu.sysu.pmglab.RuntimeProperty;
import edu.sysu.pmglab.bytecode.ByteStream;
import edu.sysu.pmglab.bytecode.Bytes;
import edu.sysu.pmglab.ccf.compressor.ICompressor;
import edu.sysu.pmglab.ccf.compressor.IDecompressor;
import edu.sysu.pmglab.ccf.meta.CCFMetaItem;
import edu.sysu.pmglab.ccf.meta.CCFOptions;
import edu.sysu.pmglab.ccf.toolkit.filter.IFilter;
import edu.sysu.pmglab.ccf.type.IFieldType;
import edu.sysu.pmglab.container.iterator.EmptyIterator;
import edu.sysu.pmglab.container.iterator.FilterIterator;
import edu.sysu.pmglab.container.list.List;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public interface ICCFOptions
extends Iterable<CCFMetaItem> {
    public static final ICCFOptions EMPTY = new ICCFOptions(){

        @Override
        public ICCFOptions add(CCFMetaItem item) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ICCFOptions adds(Iterable<CCFMetaItem> meta) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ICCFOptions clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ICCFOptions remove(String ... keys2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(String key) {
            return false;
        }

        @Override
        public Set<String> keys() {
            return Collections.EMPTY_SET;
        }

        @Override
        public <T> T get(String key) {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isModifiable() {
            return false;
        }

        @Override
        public Iterator<CCFMetaItem> iterator() {
            return EmptyIterator.INSTANCE();
        }

        @Override
        public ICCFOptions asUnmodifiable() {
            return this;
        }

        public String toString() {
            return "";
        }
    };

    public static ICCFOptions decode(Bytes codec) {
        if (codec == null || codec.length() == 0) {
            return EMPTY;
        }
        ByteStream reader = IDecompressor.decompress(RuntimeProperty.DEFAULT_DECOMPRESSOR, codec).toByteStream();
        CCFOptions container = new CCFOptions();
        while (reader.rRemaining() > 0) {
            Bytes meta = reader.getBytes();
            if (meta == null) continue;
            container.add(CCFMetaItem.decode(meta));
        }
        reader.close();
        return container.size() == 0 ? CCFOptions.EMPTY : container.asUnmodifiable();
    }

    public ICCFOptions add(CCFMetaItem var1);

    default public ICCFOptions add(String key) {
        return this.add(CCFMetaItem.of(key));
    }

    default public ICCFOptions add(String key, String value) {
        return this.add(CCFMetaItem.of(key, value));
    }

    default public ICCFOptions add(String key, String[] value) {
        return this.add(CCFMetaItem.of(key, value));
    }

    default public ICCFOptions add(String key, Set<String> value) {
        return this.add(CCFMetaItem.of(key, value));
    }

    default public ICCFOptions add(String key, List<String> value) {
        return this.add(CCFMetaItem.of(key, value));
    }

    default public ICCFOptions add(String key, IFieldType type, Object value) {
        return this.add(new CCFMetaItem(key, type, value));
    }

    default public ICCFOptions add(String key, Map<String, String> value) {
        return this.add(CCFMetaItem.of(key, value));
    }

    default public ICCFOptions adds(Iterable<CCFMetaItem> meta) {
        if (meta != null) {
            for (CCFMetaItem item : meta) {
                this.add(item);
            }
        }
        return this;
    }

    public ICCFOptions clear();

    public ICCFOptions remove(String ... var1);

    public boolean contains(String var1);

    public Set<String> keys();

    public <T> T get(String var1);

    default public <T> T getOrDefault(String key, T defaults) {
        if (this.contains(key)) {
            return this.get(key);
        }
        return defaults;
    }

    public int size();

    public boolean isModifiable();

    @Override
    public Iterator<CCFMetaItem> iterator();

    default public ICCFOptions asUnmodifiable() {
        return new ICCFOptions(){

            @Override
            public ICCFOptions add(CCFMetaItem item) {
                throw new UnsupportedOperationException();
            }

            @Override
            public ICCFOptions clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            public ICCFOptions remove(String ... keys2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean contains(String key) {
                return ICCFOptions.this.contains(key);
            }

            @Override
            public Set<String> keys() {
                return ICCFOptions.this.keys();
            }

            @Override
            public <T> T get(String key) {
                return ICCFOptions.this.get(key);
            }

            @Override
            public int size() {
                return ICCFOptions.this.size();
            }

            @Override
            public boolean isModifiable() {
                return false;
            }

            @Override
            public Iterator<CCFMetaItem> iterator() {
                return ICCFOptions.this.iterator();
            }

            @Override
            public ICCFOptions asUnmodifiable() {
                return this;
            }

            public String toString() {
                return ICCFOptions.this.toString();
            }
        };
    }

    default public Bytes encode() {
        if (this.size() == 0) {
            return Bytes.EMPTY;
        }
        ByteStream container = new ByteStream();
        for (CCFMetaItem meta : this) {
            container.putBytes(meta.encode(), true);
        }
        return ICompressor.compress(RuntimeProperty.DEFAULT_COMPRESSOR, container.toBytes());
    }

    default public Iterable<CCFMetaItem> filter(IFilter<CCFMetaItem> filter) {
        if (filter == null) {
            return this;
        }
        return () -> new FilterIterator<CCFMetaItem>(this, filter);
    }
}

