/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.record;

import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.record.IRecord;
import edu.sysu.pmglab.ccf.type.Box;

public final class BoxRecord
extends IRecord {
    final Box<?, ?>[] values;

    public BoxRecord(IFieldCollection fields) {
        super(fields.asUnmodifiable());
        this.values = new Box[this.keys.numOfFields()];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = this.keys().getFieldType(i).newBox();
        }
    }

    @Override
    public BoxRecord set(int index, Object value) {
        Box<?, ?> box = this.values[index];
        box.set(value);
        return this;
    }

    @Override
    public BoxRecord setFromBox(int index, Box<?, ?> source2) {
        if (source2 == null || source2.isNull()) {
            this.values[index].init();
        } else {
            this.values[index].setValueFrom(source2);
        }
        return this;
    }

    @Override
    public <T> T get(int index) {
        return (T)this.values[index].get();
    }

    @Override
    public void setToBox(int index, Box<?, ?> source2) {
        source2.setValueFrom(this.values[index]);
    }

    @Override
    public void clear() {
        for (Box<?, ?> value : this.values) {
            value.init();
        }
    }

    @Override
    public BoxRecord clone() {
        BoxRecord record = new BoxRecord(this.keys);
        for (int i = 0; i < this.keys.numOfFields(); ++i) {
            record.values[i].setValueFrom(this.values[i]);
        }
        return record;
    }

    public <T, V extends Box<T, V>> V getBox(int index) {
        return (V)this.values[index];
    }

    public <T, V extends Box<T, V>> V getBox(String name) {
        return (V)this.values[this.indexOf(name)];
    }

    public <T, V extends Box<T, V>> V getBox(String group, String name) {
        return (V)this.values[this.indexOf(group, name)];
    }

    public <T, V extends Box<T, V>> V getBox(FieldMeta field) {
        return (V)this.values[this.indexOf(field)];
    }
}

