/*
 * Decompiled with CFR 0.152.
 */
package edu.sysu.pmglab.ccf.record;

import edu.sysu.pmglab.ccf.field.FieldGroupMeta;
import edu.sysu.pmglab.ccf.field.FieldGroupMetas;
import edu.sysu.pmglab.ccf.field.FieldMeta;
import edu.sysu.pmglab.ccf.field.IFieldCollection;
import edu.sysu.pmglab.ccf.record.BoxRecord;
import edu.sysu.pmglab.ccf.type.Box;
import edu.sysu.pmglab.ccf.type.IFieldType;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class IRecord {
    public static final IRecord EMPTY = new IRecord(FieldGroupMeta.EMPTY){

        @Override
        public IRecord set(int index, Object value) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }

        @Override
        public IRecord setFromBox(int index, Box<?, ?> source2) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }

        @Override
        public <T> T get(int index) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }

        @Override
        public void setToBox(int index, Box<?, ?> source2) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IRecord clone() {
            return this;
        }

        @Override
        public IRecord asUnmodifiable() {
            return this;
        }
    };
    final IFieldCollection keys;

    public IRecord() {
        this.keys = new FieldGroupMetas();
    }

    public IRecord(IFieldCollection keys2) {
        this.keys = keys2;
    }

    public abstract IRecord set(int var1, Object var2);

    public final IRecord set(String name, Object value) {
        return this.set(this.indexOf(name), value);
    }

    public final IRecord set(String group, String name, Object value) {
        return this.set(this.indexOf(group, name), value);
    }

    public final IRecord set(FieldMeta field, Object value) {
        return this.set(this.indexOf(field), value);
    }

    public final void setFrom(IRecord source2, boolean fillNull) {
        if (source2 == null || source2 == this) {
            return;
        }
        if (source2 instanceof BoxRecord) {
            BoxRecord record = (BoxRecord)source2;
            if (this.keys() == record.keys()) {
                int l = this.size();
                for (int i = 0; i < l; ++i) {
                    this.set(i, source2.get(i));
                }
            } else if (fillNull) {
                int l = this.size();
                for (int i = 0; i < l; ++i) {
                    int sourceIndex = source2.indexOf(this.getField(i));
                    if (sourceIndex != -1) {
                        this.set(i, source2.get(sourceIndex));
                        continue;
                    }
                    this.set(i, null);
                }
            } else {
                int count = source2.size();
                int l = this.size();
                for (int i = 0; i < l && count != 0; ++i) {
                    int sourceIndex = source2.indexOf(this.getField(i));
                    if (sourceIndex == -1) continue;
                    this.set(i, source2.get(sourceIndex));
                    --count;
                }
            }
        } else if (this.keys() == source2.keys()) {
            int l = this.size();
            for (int i = 0; i < l; ++i) {
                this.set(i, source2.get(i));
            }
        } else if (fillNull) {
            int l = this.size();
            for (int i = 0; i < l; ++i) {
                int sourceIndex = source2.indexOf(this.getField(i));
                if (sourceIndex != -1) {
                    this.set(i, source2.get(sourceIndex));
                    continue;
                }
                this.set(i, null);
            }
        } else {
            int count = source2.size();
            int l = this.size();
            for (int i = 0; i < l && count != 0; ++i) {
                int sourceIndex = source2.indexOf(this.getField(i));
                if (sourceIndex == -1) continue;
                this.set(i, source2.get(sourceIndex));
                --count;
            }
        }
    }

    public abstract IRecord setFromBox(int var1, Box<?, ?> var2);

    public final IRecord setFromBox(String field, Box<?, ?> source2) {
        int index = this.indexOf(field);
        if (index == -1) {
            return this;
        }
        return this.setFromBox(index, source2);
    }

    public final IRecord setFromBox(String group, String field, Box<?, ?> source2) {
        int index = this.indexOf(group, field);
        if (index == -1) {
            return this;
        }
        return this.setFromBox(index, source2);
    }

    public final IRecord setFromBox(FieldMeta field, Box<?, ?> source2) {
        int index = this.indexOf(field);
        if (index == -1) {
            return this;
        }
        return this.setFromBox(index, source2);
    }

    public abstract <T> T get(int var1);

    public final <T> T get(String name) {
        return this.get(this.indexOf(name));
    }

    public final <T> T get(String group, String name) {
        return this.get(this.indexOf(group, name));
    }

    public final <T> T get(FieldMeta field) {
        return this.get(this.indexOf(field));
    }

    public abstract void setToBox(int var1, Box<?, ?> var2);

    public final void setToBox(String field, Box<?, ?> source2) {
        int index = this.indexOf(field);
        if (index == -1) {
            source2.init();
        } else {
            this.setToBox(index, source2);
        }
    }

    public final void setToBox(String group, String field, Box<?, ?> source2) {
        int index = this.indexOf(group, field);
        if (index == -1) {
            source2.init();
        } else {
            this.setToBox(index, source2);
        }
    }

    public final void setToBox(FieldMeta field, Box<?, ?> source2) {
        int index = this.indexOf(field);
        if (index == -1) {
            source2.init();
        } else {
            this.setToBox(index, source2);
        }
    }

    public final int size() {
        return this.keys.numOfFields();
    }

    public final int indexOf(String name) {
        return this.keys.indexOfField(name);
    }

    public final int indexOf(String group, String name) {
        return this.keys.indexOfField(group, name);
    }

    public final int indexOf(FieldMeta field) {
        return this.keys.indexOfField(field);
    }

    public final boolean containsGroup(String group) {
        return this.keys.containsFieldGroup(group);
    }

    public final boolean containsKey(String name) {
        return this.keys.containsField(name);
    }

    public final boolean containsKey(String group, String name) {
        return this.keys.containsField(group, name);
    }

    public final boolean containsKey(FieldMeta field) {
        return this.keys.containsField(field);
    }

    public final boolean containsKey(String name, IFieldType type) {
        return this.keys.containsField(name, type);
    }

    public final boolean containsKey(String group, String name, IFieldType type) {
        return this.keys.containsField(group, name, type);
    }

    public abstract void clear();

    public abstract IRecord clone();

    public final String toString() {
        return this.toMap().toString();
    }

    public final IFieldCollection keys() {
        return this.keys;
    }

    public final FieldMeta getField(int index) {
        return this.keys.getField(index);
    }

    public final FieldMeta getField(String name) {
        return this.keys.getField(name);
    }

    public final FieldMeta getField(String group, String name) {
        return this.keys.getField(group, name);
    }

    public IRecord asUnmodifiable() {
        return new IRecord(this.keys){

            @Override
            public IRecord set(int index, Object value) {
                throw new UnsupportedOperationException();
            }

            @Override
            public IRecord setFromBox(int index, Box<?, ?> source2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public <T> T get(int index) {
                return IRecord.this.get(index);
            }

            @Override
            public void setToBox(int index, Box<?, ?> source2) {
                IRecord.this.setToBox(index, source2);
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            public IRecord clone() {
                return this;
            }

            @Override
            public IRecord asUnmodifiable() {
                return this;
            }
        };
    }

    public final Map<String, Object> toMap() {
        LinkedHashMap map = new LinkedHashMap();
        int l = this.keys.numOfFields();
        for (int index = 0; index < l; ++index) {
            FieldMeta field = this.keys.getField(index);
            map.put(field.fullName(), this.get(field));
        }
        return Collections.unmodifiableMap(map);
    }

    void checkIndex(int index) {
        if (index < 0 || index >= this.keys.numOfFields()) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
    }
}

